/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class WMUrlClassLoader
extends URLClassLoader {
    private String loaderContext;

    public WMUrlClassLoader(URL[] urls, String loaderContext, ClassLoader parent) {
        super(urls, parent);
        this.loaderContext = loaderContext;
    }

    public WMUrlClassLoader(URL[] urls, String loaderContext) {
        this(urls, loaderContext, Thread.currentThread().getContextClassLoader());
    }

    public String toString() {
        return "WMUrlClassLoader{loaderContext='" + this.loaderContext + "'} ";
    }

    @Override
    public URL getResource(String name) {
        URL url = this.findResource(name);
        if (url == null) {
            url = super.getResource(name);
        }
        return url;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration[] tmp = new Enumeration[]{this.findResources(name), this.getParent() != null ? this.getParent().getResources(name) : Collections.emptyEnumeration()};
        return new CompoundEnumeration<URL>(tmp);
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    public static class CompoundEnumeration<E>
    implements Enumeration<E> {
        private Enumeration<E>[] enums;
        private int index;

        public CompoundEnumeration(Enumeration<E>[] enums) {
            this.enums = enums;
        }

        private boolean next() {
            while (this.index < this.enums.length) {
                if (this.enums[this.index] != null && this.enums[this.index].hasMoreElements()) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public boolean hasMoreElements() {
            return this.next();
        }

        @Override
        public E nextElement() {
            if (!this.next()) {
                throw new NoSuchElementException();
            }
            return this.enums[this.index].nextElement();
        }
    }
}

