/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.i18n;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.i18n.DefaultLocaleProvider;
import com.wavemaker.commons.i18n.LocaleMessageProviderImpl;
import java.util.Arrays;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class MessageSourceImpl
implements MessageSource {
    private LocaleMessageProviderImpl localeMessageProvider = new LocaleMessageProviderImpl();
    private DefaultLocaleProvider defaultLocaleProvider = new DefaultLocaleProvider();

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        MessageResource messageResource = MessageResource.create(code);
        return this.localeMessageProvider.getLocaleMessage(this.defaultLocaleProvider.getLocales(), messageResource, defaultMessage, args);
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        MessageResource messageResource = MessageResource.create(code);
        return this.localeMessageProvider.getLocaleMessage(this.defaultLocaleProvider.getLocales(), messageResource, code, args);
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        MessageResource messageResource = MessageResource.create(Arrays.toString(resolvable.getCodes()));
        return this.localeMessageProvider.getLocaleMessage(this.defaultLocaleProvider.getLocales(), messageResource, messageResource.getMessageKey(), resolvable.getArguments());
    }
}

