/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.local.LocalFile;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteTempFileOnCloseInputStream
extends FileInputStream {
    private java.io.File tempFile;
    private static final Logger logger = LoggerFactory.getLogger(DeleteTempFileOnCloseInputStream.class);

    public DeleteTempFileOnCloseInputStream(java.io.File tempFile) throws FileNotFoundException {
        super(tempFile);
        this.tempFile = tempFile;
    }

    public DeleteTempFileOnCloseInputStream(File tempFile) throws FileNotFoundException {
        this(((LocalFile)tempFile).getLocalFile());
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.deleteTempFile();
    }

    protected void finalize() throws IOException {
        this.deleteTempFile();
        super.finalize();
    }

    public java.io.File getTempFile() {
        return this.tempFile;
    }

    private void deleteTempFile() {
        try {
            Files.deleteIfExists(this.tempFile.toPath());
        }
        catch (Exception e) {
            logger.warn("Unable to delete the temp file {} on closing the stream.", (Object)this.tempFile, (Object)e);
        }
    }
}

