/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourceFilter;
import com.wavemaker.commons.io.ResourceFilterContext;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;

public abstract class FilterOn {
    private static final AntPathMatcher ANT_PATH_MATCHER = new AntPathMatcher();

    public static AttributeFilter names() {
        return FilterOn.getFor(new ResourceAttribute(true){

            @Override
            public String get(ResourceFilterContext context, Resource resource) {
                return resource.getName();
            }
        });
    }

    public static AttributeFilter caseSensitiveNames() {
        return FilterOn.getFor(new ResourceAttribute(false){

            @Override
            public String get(ResourceFilterContext context, Resource resource) {
                return resource.getName();
            }
        });
    }

    public static AttributeFilter paths() {
        return FilterOn.paths(PathStyle.RELATIVE_TO_SOURCE);
    }

    public static AttributeFilter paths(final PathStyle pathStyle) {
        return FilterOn.getFor(new ResourceAttribute(true){

            @Override
            public String get(ResourceFilterContext context, Resource resource) {
                return PathStyle.FULL.equals((Object)pathStyle) ? resource.toString() : resource.toStringRelativeTo(context.getSource());
            }
        });
    }

    public static AttributeFilter caseSensitivePaths() {
        return FilterOn.caseSensitivePaths(PathStyle.RELATIVE_TO_SOURCE);
    }

    public static AttributeFilter caseSensitivePaths(final PathStyle pathStyle) {
        return FilterOn.getFor(new ResourceAttribute(false){

            @Override
            public String get(ResourceFilterContext context, Resource resource) {
                return PathStyle.FULL.equals((Object)pathStyle) ? resource.toString() : resource.toStringRelativeTo(context.getSource());
            }
        });
    }

    public static AttributeFilter getFor(ResourceAttribute attribute) {
        Assert.notNull((Object)attribute, (String)"Attribute must not be null");
        return new AttributeFilter(attribute);
    }

    public static ResourceFilter hidden() {
        return FilterOn.names().starting(".");
    }

    public static ResourceFilter nonHidden() {
        return FilterOn.names().notStarting(".");
    }

    public static ResourceFilter antPattern(String ... pattern) {
        return FilterOn.antPattern(PathStyle.RELATIVE_TO_SOURCE, pattern);
    }

    public static ResourceFilter antPattern(final PathStyle pathStyle, String ... pattern) {
        final String[] patternsToUse = new String[pattern.length];
        for (int i = 0; i < pattern.length; ++i) {
            patternsToUse[i] = pattern[i].toLowerCase();
            if (PathStyle.FULL.equals((Object)pathStyle) || !patternsToUse[i].startsWith("/")) continue;
            patternsToUse[i] = patternsToUse[i].substring(1);
        }
        return new ResourceFilter(){

            @Override
            public boolean match(ResourceFilterContext context, Resource resource) {
                for (String pattern : patternsToUse) {
                    String path = PathStyle.FULL.equals((Object)pathStyle) ? resource.toString() : resource.toStringRelativeTo(context.getSource());
                    if (!ANT_PATH_MATCHER.match(pattern, path = path.toLowerCase())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static class StringFilter
    implements ResourceFilter {
        private final ResourceAttribute attribute;
        private final StringOperation operation;
        private final CharSequence value;

        public StringFilter(ResourceAttribute attribute, StringOperation operation, CharSequence value) {
            this.attribute = attribute;
            this.operation = operation;
            this.value = value;
        }

        @Override
        public boolean match(ResourceFilterContext context, Resource resource) {
            String attributeString = this.attribute.get(context, resource);
            String matchString = this.value.toString();
            if (this.attribute.isIgnoreCase()) {
                attributeString = attributeString.toLowerCase();
                matchString = matchString.toLowerCase();
            }
            switch (this.operation) {
                case STARTS: {
                    return attributeString.startsWith(matchString);
                }
                case ENDS: {
                    return attributeString.endsWith(matchString);
                }
                case CONTAINS: {
                    return attributeString.contains(matchString);
                }
                case MATCHES: {
                    return attributeString.equals(matchString);
                }
            }
            return false;
        }
    }

    private static enum StringOperation {
        STARTS,
        ENDS,
        CONTAINS,
        MATCHES;

    }

    private static class InvertFilter
    implements ResourceFilter {
        private final ResourceFilter filter;

        public InvertFilter(ResourceFilter filter) {
            this.filter = filter;
        }

        @Override
        public boolean match(ResourceFilterContext context, Resource resource) {
            return !this.filter.match(context, resource);
        }
    }

    private static class CompoundFilter
    implements ResourceFilter {
        private final List<ResourceFilter> filters = new ArrayList<ResourceFilter>();

        private CompoundFilter() {
        }

        public void add(ResourceFilter filter) {
            this.filters.add(filter);
        }

        @Override
        public boolean match(ResourceFilterContext context, Resource resource) {
            for (ResourceFilter filter : this.filters) {
                if (!filter.match(context, resource)) continue;
                return true;
            }
            return false;
        }
    }

    public static class AttributeFilter
    implements ResourceFilter {
        private final ResourceAttribute attribute;
        private AttributeFilter parent;
        private ResourceFilter filter;

        public AttributeFilter(ResourceAttribute attribute) {
            this.attribute = attribute;
        }

        public AttributeFilter(AttributeFilter parent, ResourceFilter filter) {
            this.parent = parent;
            this.attribute = parent.attribute;
            this.filter = filter;
        }

        public AttributeFilter starting(CharSequence ... prefix) {
            return new AttributeFilter(this, this.stringFilter(StringOperation.STARTS, prefix));
        }

        public AttributeFilter notStarting(CharSequence ... prefix) {
            return new AttributeFilter(this, this.not(this.stringFilter(StringOperation.STARTS, prefix)));
        }

        public AttributeFilter ending(CharSequence ... postfix) {
            return new AttributeFilter(this, this.stringFilter(StringOperation.ENDS, postfix));
        }

        public AttributeFilter notEnding(CharSequence ... postfix) {
            return new AttributeFilter(this, this.not(this.stringFilter(StringOperation.ENDS, postfix)));
        }

        public AttributeFilter containing(CharSequence ... content) {
            return new AttributeFilter(this, this.stringFilter(StringOperation.CONTAINS, content));
        }

        public AttributeFilter notContaining(CharSequence ... content) {
            return new AttributeFilter(this, this.not(this.stringFilter(StringOperation.CONTAINS, content)));
        }

        public AttributeFilter matching(CharSequence ... value) {
            return new AttributeFilter(this, this.stringFilter(StringOperation.MATCHES, value));
        }

        public AttributeFilter notMatching(CharSequence ... value) {
            return new AttributeFilter(this, this.not(this.stringFilter(StringOperation.MATCHES, value)));
        }

        private ResourceFilter stringFilter(StringOperation operation, CharSequence ... values) {
            CompoundFilter filter = new CompoundFilter();
            for (CharSequence value : values) {
                filter.add(new StringFilter(this.attribute, operation, value));
            }
            return filter;
        }

        private ResourceFilter not(ResourceFilter filter) {
            return new InvertFilter(filter);
        }

        @Override
        public boolean match(ResourceFilterContext context, Resource resource) {
            if (this.parent != null && !this.parent.match(context, resource)) {
                return false;
            }
            return this.filter == null || this.filter.match(context, resource);
        }
    }

    public static abstract class ResourceAttribute {
        private final boolean ignoreCase;

        public ResourceAttribute(boolean ignoreCase) {
            this.ignoreCase = ignoreCase;
        }

        public abstract String get(ResourceFilterContext var1, Resource var2);

        public boolean isIgnoreCase() {
            return this.ignoreCase;
        }
    }

    public static enum PathStyle {
        RELATIVE_TO_SOURCE,
        FULL;

    }
}

