/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.io.AbstractResources;
import com.wavemaker.commons.io.FilteredIterator;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourceFilter;
import com.wavemaker.commons.io.Resources;
import java.util.Iterator;
import org.springframework.util.Assert;

public class FilteredResources<T extends Resource>
extends AbstractResources<T> {
    private final Resources<T> resources;
    private final Type type;
    private final ResourceFilter[] filters;

    private FilteredResources(Resources<T> resources, Type type, ResourceFilter ... filters) {
        Assert.notNull(resources, (String)"Resources must not be null");
        Assert.notNull((Object)filters, (String)"Filters must not be null");
        this.resources = resources;
        this.filters = filters;
        this.type = type;
    }

    @Override
    public Folder getSource() {
        return this.resources.getSource();
    }

    @Override
    public Iterator<T> iterator() {
        return new FilteredIterator<T>(this.resources.iterator()){

            @Override
            protected boolean isElementFiltered(T element) {
                return FilteredResources.this.type == Type.INCLUDE ? !this.isMatch(element) : this.isMatch(element);
            }

            private boolean isMatch(T element) {
                for (ResourceFilter filter : FilteredResources.this.filters) {
                    if (!filter.match(FilteredResources.this.getResourceFilterContext(), (Resource)element)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    public static <T extends Resource> Resources<T> include(Resources<T> resources, ResourceFilter ... filters) {
        return new FilteredResources<T>(resources, Type.INCLUDE, filters);
    }

    public static <T extends Resource> Resources<T> exclude(Resources<T> resources, ResourceFilter ... filters) {
        return new FilteredResources<T>(resources, Type.EXCLUDE, filters);
    }

    private static enum Type {
        INCLUDE,
        EXCLUDE;

    }
}

