/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.ResourceNotFoundException;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.util.FileValidationUtils;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class TempFilesStorageManager {
    private static final Logger logger = LoggerFactory.getLogger(TempFilesStorageManager.class);
    private static final int CLEAN_INTERVAL = 300000;
    private static final String AUTO_PURGE_DIR = "auto-purge";
    private static final int AUTO_PURGE_TIME = 1800000;
    private Long previousCleanUpExecutedTime = System.currentTimeMillis();
    private volatile boolean purgeTaskInProgress;
    private String filesStorageDirectory = System.getProperty("wm.studio.temp.dir", System.getProperty("java.io.tmpdir")) + File.separator + "auto-purge";

    private Set<String> getSafeToDeleteFileInfo() {
        HashSet<String> safeToDeleteFileSet = new HashSet<String>();
        File rootDirectory = new File(this.filesStorageDirectory);
        File[] files = rootDirectory.listFiles();
        long purgeTime = System.currentTimeMillis() - 1800000L;
        for (File file : files) {
            long modifiedTime = file.lastModified();
            if (modifiedTime >= purgeTime) continue;
            safeToDeleteFileSet.add(file.getName());
        }
        return safeToDeleteFileSet;
    }

    public String registerNewFile(MultipartFile multipartFile) {
        InputStream inputStream;
        try {
            inputStream = multipartFile.getInputStream();
        }
        catch (IOException e) {
            throw new WMRuntimeException(e);
        }
        return this.registerNewFile(inputStream, multipartFile.getOriginalFilename());
    }

    public String registerNewFile(InputStream inputStream, String filename) {
        String fileId = this.generateUniqueId();
        return this.registerNewFile(inputStream, filename, fileId);
    }

    private String registerNewFile(InputStream inputStream, String filename, String fileId) {
        filename = StringUtils.isBlank((CharSequence)filename) ? fileId : filename;
        logger.info("Adding new temp file with fileId {} and filename {}", (Object)fileId, (Object)filename);
        File uniqueDirectory = this.getUniqueDirectory(fileId);
        uniqueDirectory.mkdirs();
        File uniqueFile = new File(uniqueDirectory, filename);
        BufferedOutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(uniqueFile));
            WMIOUtils.copy(inputStream, outputStream);
        }
        catch (IOException e) {
            try {
                WMIOUtils.deleteDirectorySilently(uniqueDirectory);
                throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.copy.input.stream.to.file"), (Throwable)e, filename);
            }
            catch (Throwable throwable) {
                WMIOUtils.closeSilently(inputStream);
                WMIOUtils.closeSilently(outputStream);
                throw throwable;
            }
        }
        WMIOUtils.closeSilently(inputStream);
        WMIOUtils.closeSilently(outputStream);
        this.purgeOldFiles();
        return fileId;
    }

    public String registerNewFile(String filename) {
        String fileId = this.generateUniqueId();
        if (StringUtils.isBlank((CharSequence)filename)) {
            filename = this.generateUniqueId();
        }
        logger.info("Adding new temp file with fileId {} and filename {}", (Object)fileId, (Object)filename);
        File uniqueDirectory = this.getUniqueDirectory(fileId);
        uniqueDirectory.mkdirs();
        File uniqueFile = new File(uniqueDirectory, FileValidationUtils.validateFilePath(filename));
        try {
            uniqueFile.createNewFile();
        }
        catch (IOException e) {
            WMIOUtils.deleteDirectorySilently(uniqueDirectory);
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.create.empty.file"), (Throwable)e, filename);
        }
        this.purgeOldFiles();
        return fileId;
    }

    public void deRegister(String fileId) {
        logger.info("DeRegistering file with unique fileId {}", (Object)fileId);
        File uniqueDirectory = this.getUniqueDirectory(fileId);
        if (uniqueDirectory.exists()) {
            WMIOUtils.deleteDirectorySilently(uniqueDirectory);
        }
    }

    public String getFileName(String fileId) {
        return this.getUniqueFile(fileId).getName();
    }

    public String getFilePath(String fileId) {
        return this.getUniqueFile(fileId).getAbsolutePath();
    }

    public InputStream getFileInputStream(String fileId) {
        File uniqueFile = this.getFile(fileId);
        try {
            return new FileInputStream(uniqueFile);
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.get.output.stream"), (Throwable)e, fileId);
        }
    }

    public File getFile(String fileId) {
        logger.info("Accessing file output stream for fileId {}", (Object)fileId);
        File uniqueFile = this.getUniqueFile(fileId);
        if (!uniqueFile.exists()) {
            throw new ResourceNotFoundException(MessageResource.create("com.wavemaker.commons.no.files.found.with.fileid"), fileId);
        }
        return uniqueFile;
    }

    public OutputStream getFileOutputStream(String fileId) {
        File uniqueFile = this.getFile(fileId);
        try {
            return new FileOutputStream(uniqueFile);
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.get.output.stream"), (Throwable)e, fileId);
        }
    }

    private String generateUniqueId() {
        String s = UUID.randomUUID().toString();
        return s.replaceAll("-", "");
    }

    private File getUniqueFile(String fileId) {
        File uniqueDirectory = this.getUniqueDirectory(fileId);
        if (!uniqueDirectory.exists()) {
            throw new IllegalStateException("Unique file not found in the temp directory with fileId:" + fileId);
        }
        File[] files = uniqueDirectory.listFiles();
        if (files.length == 1) {
            return files[0];
        }
        throw new IllegalStateException("Unique file not found in the temp directory with fileId " + fileId + ".Files count in the directory is " + files.length);
    }

    public File getUniqueDirectory(String fileId) {
        return new File(this.filesStorageDirectory, FileValidationUtils.validateFilePath(fileId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeOldFiles() {
        if (this.previousCleanUpExecutedTime + 300000L < System.currentTimeMillis()) {
            TempFilesStorageManager tempFilesStorageManager = this;
            synchronized (tempFilesStorageManager) {
                if (this.purgeTaskInProgress) {
                    return;
                }
                this.purgeTaskInProgress = true;
                try {
                    for (String fileId : this.getSafeToDeleteFileInfo()) {
                        try {
                            this.deRegister(fileId);
                        }
                        catch (Exception e) {
                            logger.error("Failed to clean up the temp file with id {}", (Object)fileId, (Object)e);
                        }
                    }
                }
                finally {
                    this.previousCleanUpExecutedTime = System.currentTimeMillis();
                    this.purgeTaskInProgress = false;
                }
            }
        }
    }
}

