/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.io.store;

import com.wavemaker.commons.io.AbstractResources;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.JailedResourcePath;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.ResourcePath;
import com.wavemaker.commons.io.ResourceStringFormat;
import com.wavemaker.commons.io.Resources;
import com.wavemaker.commons.io.ResourcesCollection;
import com.wavemaker.commons.io.exception.ResourceDoesNotExistException;
import com.wavemaker.commons.io.store.FolderStore;
import com.wavemaker.commons.io.store.StoredResource;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.springframework.util.Assert;

public abstract class StoredFolder
extends StoredResource
implements Folder {
    private static final String NAME_EMPTY_MESSAGE = "Name must not be empty";

    @Override
    protected abstract FolderStore getStore();

    @Override
    public Resource getExisting(String name) {
        Assert.hasLength((String)name, (String)NAME_EMPTY_MESSAGE);
        JailedResourcePath resourcePath = this.getPath().get(name);
        Resource resource = this.getStore().getExisting(resourcePath);
        if (resource == null) {
            throw new ResourceDoesNotExistException(this, name);
        }
        return resource;
    }

    @Override
    public boolean hasExisting(String name) {
        Assert.hasLength((String)name, (String)NAME_EMPTY_MESSAGE);
        JailedResourcePath resourcePath = this.getPath().get(name);
        Resource existing = this.getStore().getExisting(resourcePath);
        return existing != null;
    }

    @Override
    public Folder getFolder(String name) {
        Assert.hasLength((String)name, (String)NAME_EMPTY_MESSAGE);
        JailedResourcePath folderPath = this.getPath().get(name);
        return this.getStore().getFolder(folderPath);
    }

    @Override
    public File getFile(String name) {
        Assert.hasLength((String)name, (String)NAME_EMPTY_MESSAGE);
        JailedResourcePath filePath = this.getPath().get(name);
        return this.getStore().getFile(filePath);
    }

    @Override
    public <T extends Resource> T get(String name, Class<T> resourceType) {
        Assert.hasLength((String)name, (String)NAME_EMPTY_MESSAGE);
        Assert.notNull(resourceType, (String)"ResourceType must not be null");
        if (resourceType.equals(Folder.class)) {
            return (T)this.getFolder(name);
        }
        if (resourceType.equals(File.class)) {
            return (T)this.getFile(name);
        }
        return (T)this.getExisting(name);
    }

    @Override
    public Iterator<Resource> iterator() {
        return this.list().iterator();
    }

    @Override
    public Resources<Resource> list() {
        if (!this.exists()) {
            return new ResourcesCollection((Folder)this, new Resource[0]);
        }
        return new ChildResources(() -> new ChildResourceIterator(this));
    }

    @Override
    public Resources<Resource> find() {
        if (!this.exists()) {
            return new ResourcesCollection((Folder)this, new Resource[0]);
        }
        return new ChildResources(() -> new RecursiveChildResourceIterator(this));
    }

    @Override
    public Folder copyTo(Folder folder) {
        Assert.notNull((Object)folder, (String)"Folder must not be empty");
        this.ensureExists();
        Assert.state((this.getPath().getParent() != null ? 1 : 0) != 0, (String)"Unable to copy a root folder");
        Folder destination = this.createDestinationFolder(folder);
        for (Resource child : this.list()) {
            child.copyTo(destination);
        }
        return destination;
    }

    @Override
    public Resources<Resource> copyContentsTo(Folder folder) {
        return this.list().copyTo(folder);
    }

    @Override
    public Folder moveTo(Folder folder) {
        Assert.notNull((Object)folder, (String)"Folder must not be empty");
        this.ensureExists();
        Assert.state((this.getPath().getParent() != null ? 1 : 0) != 0, (String)"Unable to move a root folder");
        Folder destination = this.createDestinationFolder(folder);
        for (Resource child : this.list()) {
            child.moveTo(destination);
        }
        this.delete();
        return destination;
    }

    @Override
    public Resources<Resource> moveContentsTo(Folder folder) {
        return this.list().moveTo(folder);
    }

    private Folder createDestinationFolder(Folder folder) {
        Folder destination = folder.getFolder(this.getName());
        destination.createIfMissing();
        return destination;
    }

    @Override
    public Folder rename(String name) {
        return (Folder)super.rename(name);
    }

    @Override
    public void delete() {
        if (this.exists()) {
            for (Resource child : this.list()) {
                child.delete();
            }
            this.getStore().delete();
        }
    }

    @Override
    public void createIfMissing() {
        if (!this.exists()) {
            this.createParentIfMissing();
            this.getStore().create();
        }
    }

    @Override
    public Folder jail() {
        JailedResourcePath jailedPath = new JailedResourcePath(this.getPath().getUnjailedPath(), new ResourcePath());
        return this.getStore().getFolder(jailedPath);
    }

    @Override
    public String toString(ResourceStringFormat format) {
        return super.toString(format) + "/";
    }

    private class ChildResources
    extends AbstractResources<Resource> {
        private final Iterable<Resource> iterable;

        public ChildResources(Iterable<Resource> iterable) {
            Assert.notNull(iterable, (String)"Iterable must not be null");
            this.iterable = iterable;
        }

        @Override
        public Folder getSource() {
            return StoredFolder.this;
        }

        @Override
        public Iterator<Resource> iterator() {
            return this.iterable.iterator();
        }
    }

    private static class RecursiveChildResourceIterator
    implements Iterator<Resource> {
        private final Iterator<Resource> iterator;
        private Iterator<Resource> current;

        public RecursiveChildResourceIterator(StoredFolder folder) {
            this.iterator = new ChildResourceIterator(folder);
        }

        @Override
        public boolean hasNext() {
            return this.current != null && this.current.hasNext() || this.iterator.hasNext();
        }

        @Override
        public Resource next() {
            if (this.current != null && this.current.hasNext()) {
                return this.current.next();
            }
            this.current = null;
            Resource next = this.iterator.next();
            if (next instanceof StoredFolder) {
                StoredFolder folder = (StoredFolder)next;
                this.current = new RecursiveChildResourceIterator(folder);
            }
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ChildResourceIterator
    implements Iterator<Resource> {
        private final StoredFolder folder;
        private final Iterator<String> childNames;
        private Resource next;

        public ChildResourceIterator(StoredFolder folder) {
            this.folder = folder;
            Iterable<String> list = folder.getStore().list();
            this.childNames = list == null ? Collections.emptyList().iterator() : list.iterator();
        }

        @Override
        public boolean hasNext() {
            this.ensureNextHasBeenFetched();
            return this.next != null;
        }

        @Override
        public Resource next() {
            try {
                this.ensureNextHasBeenFetched();
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Resource resource = this.next;
                return resource;
            }
            finally {
                this.next = null;
            }
        }

        private void ensureNextHasBeenFetched() {
            while (this.next == null && this.childNames.hasNext()) {
                String name = this.childNames.next();
                JailedResourcePath path = this.folder.getStore().getPath().get(name);
                Resource resource = this.folder.getStore().getExisting(path);
                if (resource == null) continue;
                this.next = resource;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

