/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.SqlDateSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;

public class JSONUtils {
    private static final ObjectMapper objectMapper = new ObjectMapper();

    private JSONUtils() {
    }

    public static String prettifyJSON(String data) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)data)) {
            JsonNode tree = objectMapper.readTree(data);
            return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)tree);
        }
        return data;
    }

    public static void prettifyJSON(String data, File outputFile) throws IOException {
        if (data == null) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.null.json.prettify.error"));
        }
        String formattedJson = JSONUtils.prettifyJSON(data);
        WMIOUtils.write(outputFile, formattedJson);
    }

    public static String toJSON(Object object) {
        try {
            return JSONUtils.toJSON(object, true);
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.objToJsonConversionFailed"), (Throwable)e);
        }
    }

    public static String toJSON(Object object, boolean prettify) throws IOException {
        return prettify ? objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString(object) : objectMapper.writeValueAsString(object);
    }

    public static void toJSON(File outputFile, Object object) throws IOException {
        JSONUtils.toJSON(outputFile, object, true);
    }

    public static void toJSON(File outputFile, Object object, boolean prettify) throws IOException {
        if (prettify) {
            objectMapper.writerWithDefaultPrettyPrinter().writeValue(outputFile, object);
        } else {
            objectMapper.writeValue(outputFile, object);
        }
    }

    public static void toJSON(OutputStream outputStream, Object object) throws IOException {
        JSONUtils.toJSON(outputStream, object, true);
    }

    public static void toJSON(OutputStream outputStream, Object object, boolean prettify) throws IOException {
        try {
            if (prettify) {
                objectMapper.writerWithDefaultPrettyPrinter().writeValue(outputStream, object);
            } else {
                objectMapper.writeValue(outputStream, object);
            }
        }
        finally {
            WMIOUtils.closeSilently(outputStream);
        }
    }

    public static void toJSON(Writer outputWriter, Object object) throws IOException {
        JSONUtils.toJSON(outputWriter, object, true);
    }

    public static void toJSON(Writer outputWriter, Object object, boolean prettify) throws IOException {
        try {
            if (prettify) {
                objectMapper.writerWithDefaultPrettyPrinter().writeValue(outputWriter, object);
            } else {
                objectMapper.writeValue(outputWriter, object);
            }
        }
        finally {
            WMIOUtils.closeSilently(outputWriter);
        }
    }

    public static <T> T toObject(String jsonString, Class<T> t) throws IOException {
        return (T)objectMapper.readValue(jsonString, t);
    }

    public static <T> T toObject(Reader jsonReader, Class<T> t) throws IOException {
        try {
            Object object = objectMapper.readValue(jsonReader, t);
            return (T)object;
        }
        finally {
            WMIOUtils.closeSilently(jsonReader);
        }
    }

    public static <T> T toObject(InputStream jsonStream, Class<T> t) throws IOException {
        try {
            Object object = objectMapper.readValue(jsonStream, t);
            return (T)object;
        }
        finally {
            WMIOUtils.closeSilently(jsonStream);
        }
    }

    public static <T> T toObject(File file, Class<T> targetClass) throws IOException {
        return (T)objectMapper.readValue(file, targetClass);
    }

    public static <T> T toObject(File file, JavaType javaType) throws IOException {
        return (T)objectMapper.readValue(file, javaType);
    }

    public static <T> T toObject(String jsonString, TypeReference<T> valueTypeRef) throws IOException {
        return (T)objectMapper.readValue(jsonString, valueTypeRef);
    }

    public static <T> T toObject(InputStream inputStream, TypeReference<T> typeReference) throws IOException {
        try {
            Object object = objectMapper.readValue(inputStream, typeReference);
            return (T)object;
        }
        finally {
            WMIOUtils.closeSilently(inputStream);
        }
    }

    public static <T> T toObject(Reader reader, TypeReference<T> typeReference) throws IOException {
        try {
            Object object = objectMapper.readValue(reader, typeReference);
            return (T)object;
        }
        finally {
            WMIOUtils.closeSilently(reader);
        }
    }

    public static <T> T convert(Object object, Class<T> targetClass) {
        return (T)objectMapper.convertValue(object, targetClass);
    }

    public static void registerModule(Module module) {
        objectMapper.registerModule(module);
    }

    public static JsonNode readTree(InputStream inputStream) {
        try {
            JsonNode jsonNode = objectMapper.readTree(inputStream);
            return jsonNode;
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.jsonData.parse.failed"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeSilently(inputStream);
        }
    }

    public static JsonNode readTree(String str) {
        try {
            return objectMapper.readTree(str);
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.jsonData.parse.failed"), (Throwable)e);
        }
    }

    static {
        objectMapper.setTypeFactory(TypeFactory.defaultInstance().withClassLoader(JSONUtils.class.getClassLoader()));
        SimpleModule module = new SimpleModule();
        module.addSerializer(Date.class, (JsonSerializer)new SqlDateSerializer().withFormat(Boolean.valueOf(false), (DateFormat)new SimpleDateFormat("yyyy-MM-dd")));
        objectMapper.registerModule((Module)module);
    }
}

