/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.json.deserializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.DateDeserializers;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import java.io.IOException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WMDateDeSerializer
extends DateDeserializers.DateDeserializer {
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd";
    private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss";
    private static final String DEFAULT_DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final Logger logger = LoggerFactory.getLogger(WMDateDeSerializer.class);

    public Date deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        JsonToken currentToken = jsonParser.getCurrentToken();
        if (currentToken == JsonToken.VALUE_STRING) {
            String value = jsonParser.getText();
            return WMDateDeSerializer.getDate(value);
        }
        return super.deserialize(jsonParser, deserializationContext);
    }

    public static Date getDate(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            Date parsedDate = new SimpleDateFormat(DEFAULT_DATE_TIME_FORMAT).parse(value);
            return new Timestamp(parsedDate.getTime());
        }
        catch (ParseException e) {
            logger.trace("{} is not in the expected date time format {}", (Object)value, (Object)DEFAULT_DATE_TIME_FORMAT);
            try {
                Date parsedDate = new SimpleDateFormat(DEFAULT_DATE_FORMAT).parse(value);
                return new java.sql.Date(parsedDate.getTime());
            }
            catch (ParseException e2) {
                logger.trace("{} is not in the expected date format {}", (Object)value, (Object)DEFAULT_DATE_FORMAT);
                try {
                    Date parsedDate = new SimpleDateFormat(DEFAULT_TIME_FORMAT).parse(value);
                    return new Time(parsedDate.getTime());
                }
                catch (ParseException e3) {
                    logger.trace("{} is not in the expected time format {}", (Object)value, (Object)DEFAULT_TIME_FORMAT);
                    throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.string.to.date.parse.failure"), value, "java.util.Date");
                }
            }
        }
    }
}

