/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.swaggerdoc.handler;

import com.wavemaker.tools.apidocs.tools.core.model.AbstractModel;
import com.wavemaker.tools.apidocs.tools.core.model.Model;
import com.wavemaker.tools.apidocs.tools.core.model.Operation;
import com.wavemaker.tools.apidocs.tools.core.model.Response;
import com.wavemaker.tools.apidocs.tools.core.model.properties.Property;
import com.wavemaker.tools.apidocs.tools.core.model.properties.RefProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class OperationHandler {
    private static final String SUCCESS_RESPONSE_CODE = "200";
    private final Operation operation;
    private final Map<String, Model> models;

    public OperationHandler(Operation operation, Map<String, Model> models) {
        this.operation = operation;
        this.models = models;
    }

    public String getFullyQualifiedReturnType() {
        Response successResponse;
        Map response = this.operation.getResponses();
        if (response != null && (successResponse = (Response)response.get(SUCCESS_RESPONSE_CODE)) != null) {
            Property property = successResponse.getSchema();
            if (property instanceof RefProperty) {
                RefProperty refProperty = (RefProperty)property;
                Model model = this.models.get(refProperty.getSimpleRef());
                return ((AbstractModel)model).getFullyQualifiedName();
            }
            if (property != null) {
                return property.getType();
            }
        }
        return null;
    }

    public List<String> getFullyQualifiedArgumentReturnType() {
        Map response = this.operation.getResponses();
        Response successResponse = (Response)response.get(SUCCESS_RESPONSE_CODE);
        Property property = successResponse.getSchema();
        if (property instanceof RefProperty) {
            RefProperty refProperty = (RefProperty)property;
            List typeArgumentsProperties = refProperty.getTypeArguments();
            if (typeArgumentsProperties.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<String> argumentTypeList = new ArrayList<String>();
            for (Property argProperty : typeArgumentsProperties) {
                if (property instanceof RefProperty) {
                    RefProperty refArgProperty = (RefProperty)property;
                    Model argModel = this.models.get(refArgProperty.getSimpleRef());
                    argumentTypeList.add(((AbstractModel)argModel).getFullyQualifiedName());
                    continue;
                }
                argumentTypeList.add(argProperty.getType());
            }
            return argumentTypeList;
        }
        return Collections.emptyList();
    }
}

