/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.swaggerdoc.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.SwaggerException;
import com.wavemaker.tools.apidocs.tools.core.model.ArrayModel;
import com.wavemaker.tools.apidocs.tools.core.model.ComposedModel;
import com.wavemaker.tools.apidocs.tools.core.model.Model;
import com.wavemaker.tools.apidocs.tools.core.model.Operation;
import com.wavemaker.tools.apidocs.tools.core.model.Path;
import com.wavemaker.tools.apidocs.tools.core.model.RefModel;
import com.wavemaker.tools.apidocs.tools.core.model.Swagger;
import com.wavemaker.tools.apidocs.tools.core.model.parameters.AbstractParameter;
import com.wavemaker.tools.apidocs.tools.core.model.parameters.FormParameter;
import com.wavemaker.tools.apidocs.tools.core.model.parameters.Parameter;
import com.wavemaker.tools.apidocs.tools.core.model.properties.ArrayProperty;
import com.wavemaker.tools.apidocs.tools.core.model.properties.DateProperty;
import com.wavemaker.tools.apidocs.tools.core.model.properties.ObjectProperty;
import com.wavemaker.tools.apidocs.tools.core.model.properties.Property;
import com.wavemaker.tools.apidocs.tools.core.model.properties.PropertyBuilder;
import com.wavemaker.tools.apidocs.tools.core.model.properties.RefProperty;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SwaggerDocUtil {
    public static final String FILE = "file";
    public static final String ARRAY = "array";
    public static final String STRING = "string";
    private static final String INT64 = "int64";
    private static final String INT32 = "int32";
    private static final String INTEGER = "integer";
    private static final String FLOAT = "float";
    private static final String DATE_TIME_TYPE = "date-time";
    private static final String DOUBLE_TYPE = "double";
    private static final String NUMBER_TYPE = "number";
    private static final String OPERATION_DOES_NOT_EXIST = "com.wavemaker.runtime.operation.doesnt.exist";

    public static Path getPathByEndPoint(Swagger swagger, String endPoint) {
        for (Map.Entry pathEntry : swagger.getPaths().entrySet()) {
            if (!((String)pathEntry.getKey()).equals(endPoint)) continue;
            return (Path)pathEntry.getValue();
        }
        throw new SwaggerException(MessageResource.create("com.wavemaker.commons.path.does.not.exist.with.endPoint"), endPoint);
    }

    public static Path getPathByOperationUid(Swagger swagger, String operationUid) {
        for (Map.Entry pathEntry : swagger.getPaths().entrySet()) {
            for (Operation operation : ((Path)pathEntry.getValue()).getOperations()) {
                if (!operationUid.equals(operation.getOperationId())) continue;
                return (Path)pathEntry.getValue();
            }
        }
        throw new SwaggerException(MessageResource.create(OPERATION_DOES_NOT_EXIST), operationUid);
    }

    public static Operation getOperationByUid(Swagger swagger, String operationUid) {
        for (Map.Entry pathEntry : swagger.getPaths().entrySet()) {
            for (Operation operation : ((Path)pathEntry.getValue()).getOperations()) {
                if (!operationUid.equals(operation.getOperationId())) continue;
                return operation;
            }
        }
        throw new SwaggerException(MessageResource.create(OPERATION_DOES_NOT_EXIST), operationUid);
    }

    public static Operation getOperation(Swagger swagger, String endPoint, String operationUid) {
        Path path = Objects.requireNonNull((Path)swagger.getPaths().get(endPoint), "Endpoint does not exist with id " + endPoint);
        for (Operation operation : path.getOperations()) {
            if (!operationUid.equals(operation.getOperationId())) continue;
            return operation;
        }
        throw new SwaggerException(MessageResource.create(OPERATION_DOES_NOT_EXIST), operationUid);
    }

    public static String getOperationType(Path path, String operationUid) {
        Operation operationGet = path.getGet();
        Operation operationPost = path.getPost();
        Operation operationDelete = path.getDelete();
        Operation operationPatch = path.getPatch();
        Operation operationPut = path.getPut();
        Operation operationOptions = path.getOptions();
        OperationType operationType = null;
        if (operationGet != null && operationGet.getOperationId().equals(operationUid)) {
            operationType = OperationType.GET;
        }
        if (operationPost != null && operationPost.getOperationId().equals(operationUid)) {
            operationType = OperationType.POST;
        }
        if (operationDelete != null && operationDelete.getOperationId().equals(operationUid)) {
            operationType = OperationType.DELETE;
        }
        if (operationPatch != null && operationPatch.getOperationId().equals(operationUid)) {
            operationType = OperationType.PATCH;
        }
        if (operationPut != null && operationPut.getOperationId().equals(operationUid)) {
            operationType = OperationType.PUT;
        }
        if (operationOptions != null && operationOptions.getOperationId().equals(operationUid)) {
            operationType = OperationType.OPTIONS;
        }
        if (operationType != null) {
            return operationType.name().toLowerCase();
        }
        throw new SwaggerException(MessageResource.create(OPERATION_DOES_NOT_EXIST), operationUid);
    }

    public static Property buildProperty(String type, String format) {
        if ("boolean".equals(type)) {
            return PropertyBuilder.build((String)type, null, null);
        }
        if ("date".equals(type)) {
            return PropertyBuilder.build((String)STRING, (String)"date", null);
        }
        if (DATE_TIME_TYPE.equals(type)) {
            return PropertyBuilder.build((String)STRING, (String)DATE_TIME_TYPE, null);
        }
        if (DOUBLE_TYPE.equals(type)) {
            return PropertyBuilder.build((String)NUMBER_TYPE, (String)DOUBLE_TYPE, null);
        }
        if (FLOAT.equals(type)) {
            return PropertyBuilder.build((String)NUMBER_TYPE, (String)FLOAT, null);
        }
        if (FILE.equals(type)) {
            return PropertyBuilder.build((String)FILE, null, null);
        }
        if (NUMBER_TYPE.equals(type)) {
            return PropertyBuilder.build((String)NUMBER_TYPE, null, null);
        }
        if (INTEGER.equals(type) && INT32.equals(format)) {
            return PropertyBuilder.build((String)INTEGER, (String)format, null);
        }
        if (INTEGER.equals(type) && INT64.equals(format)) {
            return PropertyBuilder.build((String)INTEGER, (String)format, null);
        }
        if (INTEGER.equals(type)) {
            return PropertyBuilder.build((String)INTEGER, (String)INT32, null);
        }
        if ("long".equals(type)) {
            return PropertyBuilder.build((String)INTEGER, (String)INT64, null);
        }
        if ("$ref".equals(type)) {
            return PropertyBuilder.build((String)"$ref", (String)format, null);
        }
        if (STRING.equals(type) && "uuid".equals(format)) {
            return PropertyBuilder.build((String)STRING, (String)"uuid", null);
        }
        if (STRING.equals(type)) {
            return PropertyBuilder.build((String)STRING, null, null);
        }
        return null;
    }

    public static String getWrapperPropertyFQType(Property property) {
        String type = property.getType();
        String format = property.getFormat();
        if (property instanceof DateProperty) {
            DateProperty dateProperty = (DateProperty)property;
            return SwaggerDocUtil.findDateType(dateProperty).getName();
        }
        if ("boolean".equals(type)) {
            return Boolean.class.getName();
        }
        if (NUMBER_TYPE.equals(type) && DOUBLE_TYPE.equals(format)) {
            return Double.class.getName();
        }
        if (NUMBER_TYPE.equals(type) && FLOAT.equals(format)) {
            return Float.class.getName();
        }
        if (INTEGER.equals(type) && INT32.equals(format)) {
            return Integer.class.getName();
        }
        if (INTEGER.equals(type) && INT64.equals(format)) {
            return Long.class.getName();
        }
        if (STRING.equals(type) && "uuid".equals(format)) {
            return String.class.getName();
        }
        if (STRING.equals(type)) {
            return String.class.getName();
        }
        return null;
    }

    public static String getParameterType(Parameter parameter) {
        String fullyQualifiedType = null;
        if (parameter instanceof FormParameter) {
            FormParameter formParameter = (FormParameter)parameter;
            if (ARRAY.equals(formParameter.getType())) {
                fullyQualifiedType = formParameter.getItems().getType();
            } else if (FILE.equals(formParameter.getType())) {
                fullyQualifiedType = formParameter.getType();
            } else if (STRING.equals(formParameter.getType()) && ((AbstractParameter)parameter).getFullyQualifiedType() != null) {
                fullyQualifiedType = ((AbstractParameter)parameter).getFullyQualifiedType();
            }
        } else {
            fullyQualifiedType = ((AbstractParameter)parameter).getFullyQualifiedType();
        }
        return fullyQualifiedType == null ? String.class.getSimpleName() : fullyQualifiedType;
    }

    public static Class<?> findDateType(DateProperty property) {
        Class javaType = Date.class;
        if (DATE_TIME_TYPE.equals(property.getSubFormat())) {
            javaType = LocalDateTime.class;
        } else if ("time".equals(property.getSubFormat())) {
            javaType = Time.class;
        } else if ("timestamp".equals(property.getSubFormat())) {
            javaType = Timestamp.class;
        }
        return javaType;
    }

    public static Map<String, Property> getProperties(Swagger swagger, Model model) {
        LinkedHashMap<String, Property> propertyMap = new LinkedHashMap<String, Property>();
        if (model instanceof ComposedModel) {
            List parentModels = ((ComposedModel)model).getAllOf();
            for (Model parent : parentModels) {
                propertyMap.putAll(SwaggerDocUtil.getProperties(swagger, parent));
            }
        } else if (model instanceof RefModel) {
            Model refModel = (Model)swagger.getDefinitions().get(((RefModel)model).getSimpleRef());
            if (refModel != null) {
                propertyMap.putAll(SwaggerDocUtil.getProperties(swagger, refModel));
            }
        } else if (model instanceof ArrayModel) {
            ArrayProperty arrayProperty = new ArrayProperty();
            arrayProperty.setItems(((ArrayModel)model).getItems());
            propertyMap.putAll(SwaggerDocUtil.getProperties(swagger, ((ArrayModel)model).getItems()));
        }
        if (model.getProperties() != null) {
            propertyMap.putAll(model.getProperties());
        }
        return propertyMap;
    }

    public static Map<String, Property> getProperties(Swagger swagger, Property property) {
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        if (property instanceof ArrayProperty) {
            Property items = ((ArrayProperty)property).getItems();
            if (items instanceof ObjectProperty) {
                propertyMap.putAll(SwaggerDocUtil.getPropertiesFromObjectProperty(swagger, (ObjectProperty)items));
            }
        } else if (property instanceof ObjectProperty) {
            propertyMap.putAll(SwaggerDocUtil.getPropertiesFromObjectProperty(swagger, (ObjectProperty)property));
        } else if (property instanceof RefProperty) {
            Model model = (Model)swagger.getDefinitions().get(((RefProperty)property).getSimpleRef());
            propertyMap.putAll(SwaggerDocUtil.getProperties(swagger, model));
        }
        return propertyMap;
    }

    private static Map<String, Property> getPropertiesFromObjectProperty(Swagger swagger, ObjectProperty property) {
        HashMap<String, Property> propertyMap = new HashMap<String, Property>();
        List models = property.getAllOf();
        for (Model model : models) {
            propertyMap.putAll(SwaggerDocUtil.getProperties(swagger, model));
        }
        if (property.getProperties() != null) {
            propertyMap.putAll(property.getProperties());
        }
        return propertyMap;
    }

    static enum OperationType {
        GET,
        POST,
        DELETE,
        PUT,
        PATCH,
        OPTIONS;

    }
}

