/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FilePatternMatchVisitor
extends SimpleFileVisitor<Path> {
    private final PathMatcher matcher;
    private List<Path> matchedPaths = new ArrayList<Path>();
    private Path basePath;

    public FilePatternMatchVisitor(String pattern, String basePath) {
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
        this.basePath = Paths.get(basePath, new String[0]);
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
        this.addToListIfMatching(file);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
        this.addToListIfMatching(dir);
        return FileVisitResult.CONTINUE;
    }

    public Collection<Path> getMatchedPaths() {
        return this.matchedPaths;
    }

    private void addToListIfMatching(Path file) {
        Path name = this.basePath.relativize(file);
        if (name != null && this.matcher.matches(name)) {
            this.matchedPaths.add(name);
        }
    }
}

