/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.MethodNotFoundRuntimeException;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.classloader.ClassLoaderUtils;
import com.wavemaker.commons.util.ClassUtils;
import com.wavemaker.commons.util.TypeConversionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ObjectAccess {
    private static ObjectAccess instance = new ObjectAccess();

    public static ObjectAccess getInstance() {
        return instance;
    }

    private ObjectAccess() {
    }

    public Object newInstance(Class<?> clazz) {
        if (List.class.isAssignableFrom(clazz)) {
            clazz = ArrayList.class;
        } else if (Collection.class.isAssignableFrom(clazz)) {
            clazz = HashSet.class;
        } else if (Map.class.isAssignableFrom(clazz)) {
            clazz = HashMap.class;
        }
        return ClassUtils.newInstance(clazz);
    }

    public Class<?> forName(String className) {
        return ClassLoaderUtils.loadClass(className);
    }

    public <T> T invoke(Object o, String methodName) {
        return this.invoke(o, methodName, null);
    }

    public <T> T invoke(Object o, String methodName, Object ... params) {
        Class[] paramTypes = null;
        boolean paramIsNull = false;
        if (params != null) {
            paramTypes = new Class[params.length];
            for (int i = 0; i < params.length; ++i) {
                if (paramTypes[i] == null) {
                    paramIsNull = true;
                    continue;
                }
                paramTypes[i] = this.getClassForObject(params[i]);
            }
        }
        Class<?> c = this.getClassForObject(o);
        Method m = null;
        m = paramIsNull ? this.getMethod(c, methodName, paramTypes.length) : this.getMethod(c, methodName, paramTypes);
        if (m == null) {
            throw new MethodNotFoundRuntimeException(methodName, c, paramTypes);
        }
        return (T)this.invokeInternal(o, m, params);
    }

    public <T> T getProperty(Object o, String propertyName) {
        Method m = this.getGetterMethod(this.getClassForObject(o), propertyName);
        if (m != null) {
            return (T)this.invokeInternal(o, m, null);
        }
        throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.getter.method.not.found"), propertyName, o.getClass().getName());
    }

    public void setProperty(Object o, String propertyName, Object propertyValue) {
        this.invoke(o, ClassUtils.getPropertySetterName(propertyName), propertyValue);
    }

    public Class<?> getPropertyType(Class<?> clazz, String propertyName) {
        if (clazz == null) {
            throw new IllegalArgumentException("class cannot be null");
        }
        if (propertyName == null) {
            throw new IllegalArgumentException("property name cannot be null");
        }
        Method m = this.getMethod(clazz, ClassUtils.getPropertySetterName(propertyName), 1);
        if (m != null) {
            return m.getParameterTypes()[0];
        }
        return null;
    }

    public boolean propertyIsNull(Object o, String propertyName) {
        return this.getProperty(o, propertyName) == null;
    }

    public List<Class<?>> getMethodParamTypes(Class<?> clazz, String methodName, int numParams) {
        Method m = this.getMethod(clazz, methodName, numParams);
        if (m != null) {
            return Arrays.asList(m.getParameterTypes());
        }
        return Collections.emptyList();
    }

    public Class<?> getMethodReturnType(Class<?> clazz, String methodName, int numParams) {
        Method m = this.getMethod(clazz, methodName, numParams);
        if (m != null) {
            return m.getReturnType();
        }
        return null;
    }

    public List<Class<?>> getGenericReturnTypes(Class<?> clazz, String methodName, int numParams) {
        Method m = this.getMethod(clazz, methodName, numParams);
        if (m == null) {
            return Collections.emptyList();
        }
        return this.getGenericReturnTypes(m);
    }

    private List<Class<?>> getGenericReturnTypes(Method m) {
        List<Class<?>> rtn = Collections.emptyList();
        Type t = m.getGenericReturnType();
        if (t instanceof ParameterizedType) {
            Type[] gt = ((ParameterizedType)t).getActualTypeArguments();
            rtn = new ArrayList(gt.length);
            for (Type i : gt) {
                rtn.add((Class)i);
            }
        }
        return rtn;
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> annotation, Object o, String methodName) {
        return this.hasAnnotation(annotation, o, methodName, null);
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> annotation, Object o, String methodName, Class<?> ... paramTypes) {
        Method m = this.getMethod(this.getClassForObject(o), methodName, paramTypes);
        if (m == null) {
            return false;
        }
        return m.getAnnotation(annotation) != null;
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> annotation, Object o, String methodName, int numParams) {
        Method m = this.getMethod(this.getClassForObject(o), methodName, numParams);
        if (m == null) {
            return false;
        }
        return m.getAnnotation(annotation) != null;
    }

    public boolean hasProperty(Class<?> clazz, String propertyName) {
        try {
            this.getGetterMethod(clazz, propertyName);
            return true;
        }
        catch (MethodNotFoundRuntimeException ex) {
            return false;
        }
    }

    public boolean hasMethod(Class<?> clazz, String methodName, int numParams) {
        Method m = this.getMethod(clazz, methodName, numParams);
        return m != null;
    }

    public List<String> getPropertyNames(Class<?> clazz) {
        Map<String, Class<?>> m = this.getProperties(clazz);
        ArrayList<String> rtn = new ArrayList<String>(m.size());
        for (String s : m.keySet()) {
            rtn.add(s);
        }
        return rtn;
    }

    public Map<String, Class<?>> getProperties(Class<?> clazz) {
        LinkedHashMap rtn = new LinkedHashMap();
        HashSet<String> methodNames = new HashSet<String>();
        for (Method m : this.getMethods(clazz)) {
            methodNames.add(m.getName());
        }
        for (String s : methodNames) {
            String propName;
            Class<?> type;
            String prop;
            if (!s.startsWith("get") || !methodNames.contains("set" + (prop = s.substring(3))) || (type = this.getPropertyType(clazz, propName = StringUtils.uncapitalize((String)prop))) == null) continue;
            rtn.put(propName, type);
        }
        return rtn;
    }

    public String objectToString(Object o) {
        return this.objectToString(o, true);
    }

    public String objectToString(Object o, boolean excludeContainers) {
        if (o == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(o.getClass().getName()).append(":");
        if (TypeConversionUtils.isPrimitiveOrWrapper(o.getClass())) {
            sb.append(String.valueOf(o));
            return sb.toString();
        }
        sb.append("{");
        Map<String, Class<?>> propNames = this.getProperties(this.getClassForObject(o));
        int i = 0;
        for (Map.Entry<String, Class<?>> e : propNames.entrySet()) {
            Object v = this.getProperty(o, e.getKey());
            if (excludeContainers) {
                if (v instanceof Collection) {
                    if (!((Collection)v).isEmpty()) {
                        v = "[...]";
                    }
                } else if (v instanceof Map && !((Map)v).isEmpty()) {
                    v = "{...}";
                }
            }
            sb.append(e.getKey()).append(":").append(v);
            if (i++ >= propNames.size() - 1) continue;
            sb.append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private Method getGetterMethod(Class<?> clazz, String propertyName) {
        String name = ClassUtils.getPropertyGetterName(propertyName);
        if (this.hasMethod(clazz, name, 0)) {
            return this.getMethod(clazz, name, 0);
        }
        String altName = ClassUtils.getAltPropertyGetterName(propertyName);
        if (this.hasMethod(clazz, altName, 0)) {
            return this.getMethod(clazz, altName, 0);
        }
        throw new MethodNotFoundRuntimeException(name, clazz, null);
    }

    private Class<?> getClassForObject(Object o) {
        if (o == null) {
            throw new IllegalArgumentException("getClassForObject: instance cannot be null");
        }
        return o.getClass();
    }

    private Method getMethod(Class<?> c, String methodName, int numParams) {
        for (Method m : this.getMethods(c)) {
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != numParams) continue;
            return m;
        }
        return null;
    }

    private Method getMethod(Class<?> c, String methodName, Class<?> ... paramTypes) {
        for (Method m : this.getMethods(c)) {
            if (!m.getName().equals(methodName) || !this.paramsMatch(m, paramTypes)) continue;
            return m;
        }
        return null;
    }

    private boolean paramsMatch(Method m, Class<?> ... paramTypes) {
        Class<?>[] methodParams = m.getParameterTypes();
        if (methodParams.length == 0) {
            return paramTypes == null || paramTypes.length == 0;
        }
        if (paramTypes == null || methodParams.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < methodParams.length; ++i) {
            if (methodParams[i].isAssignableFrom(paramTypes[i]) || TypeConversionUtils.primitivesMatch(methodParams[i], paramTypes[i])) continue;
            return false;
        }
        return true;
    }

    private Method[] getMethods(Class<?> clazz) {
        return clazz.getMethods();
    }

    private Object invokeInternal(Object instance, Method m, Object[] params) {
        try {
            return m.invoke(instance, params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
            throw new WMRuntimeException(ex);
        }
    }
}

