/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import java.io.BufferedReader;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import java.util.function.Function;

public class PatternMatchingReplaceReader
extends FilterReader {
    private String prefix;
    private String suffix;
    private StringBuilder sb = new StringBuilder();
    private Function<String, String> function;

    public PatternMatchingReplaceReader(Reader in, String prefix, String suffix, Function<String, String> function) {
        super(new BufferedReader(in));
        this.prefix = prefix;
        this.suffix = suffix;
        this.function = function;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        int count = 0;
        boolean eof = false;
        while (count < len) {
            int read = this.read();
            if (read == -1) {
                eof = true;
                break;
            }
            cbuf[off + count++] = (char)read;
        }
        if (count == 0 && eof) {
            return -1;
        }
        return count;
    }

    @Override
    public int read(char[] cbuf) throws IOException {
        return this.read(cbuf, 0, cbuf.length);
    }

    @Override
    public int read() throws IOException {
        block0: while (true) {
            char ch;
            StringBuilder tempSb;
            int count;
            boolean prefixFound;
            block8: {
                if (this.sb.length() != 0) {
                    char ch2 = this.sb.charAt(0);
                    this.sb = this.sb.deleteCharAt(0);
                    return ch2 == '\uffff' ? -1 : (int)ch2;
                }
                prefixFound = false;
                count = 0;
                tempSb = new StringBuilder();
                do {
                    ch = (char)this.readNextChar();
                    tempSb.append(ch);
                    if (this.prefix.charAt(count) == ch) {
                        ++count;
                        continue;
                    }
                    this.sb.append((CharSequence)tempSb);
                    break block8;
                } while (tempSb.length() != this.prefix.length());
                prefixFound = true;
            }
            if (!prefixFound) continue;
            count = 0;
            tempSb = new StringBuilder();
            while (true) {
                ch = (char)this.readNextChar();
                tempSb.append(ch);
                if (this.suffix.charAt(count) == ch) {
                    if (this.suffix.length() != ++count) continue;
                    String key = tempSb.substring(0, tempSb.length() - this.suffix.length());
                    String val = this.function.apply(key);
                    if (val != null) {
                        this.sb.append(val);
                        continue block0;
                    }
                    this.sb.append(this.prefix + key + this.suffix);
                    continue block0;
                }
                if (!this.isValidChar(ch)) {
                    this.sb.append(this.prefix).append((CharSequence)tempSb);
                    continue block0;
                }
                count = 0;
            }
            break;
        }
    }

    private boolean isValidChar(int ch) {
        return Character.isLetter(ch) || Character.isDigit(ch) || ch == 46 || ch == 45 || ch == 95;
    }

    private int readNextChar() throws IOException {
        int read = super.read();
        return read;
    }
}

