/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.properties.PropertiesWriter;
import com.wavemaker.commons.properties.SortedProperties;
import com.wavemaker.commons.util.WMIOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.Properties;

public class PropertiesFileUtils {
    private PropertiesFileUtils() {
    }

    public static Properties loadFromXml(File file) {
        InputStream inputStream = null;
        try {
            inputStream = file.getContent().asInputStream();
            Properties properties = new Properties();
            properties.loadFromXML(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.properties.inputStream.read.failure"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeSilently(inputStream);
        }
    }

    public static Properties loadProperties(File file) {
        return PropertiesFileUtils.loadProperties(file.getContent().asInputStream());
    }

    public static Properties loadProperties(InputStream inputStream) {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.load.properties"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeByLogging(inputStream);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeToXml(Properties properties, File file, String comment) {
        OutputStream outputStream = null;
        try {
            outputStream = file.getContent().asOutputStream();
            PropertiesWriter propertiesWriter = new PropertiesWriter(properties);
            propertiesWriter.setComments(comment).setToXML(true).setSortProperties(true);
            propertiesWriter.write(outputStream);
        }
        finally {
            WMIOUtils.closeSilently(outputStream);
        }
    }

    public static Properties sortProperties(Properties properties) {
        SortedProperties sortedProperties = new SortedProperties();
        sortedProperties.putAll((Map<?, ?>)properties);
        return sortedProperties;
    }
}

