/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLUtils {
    private static final Logger logger = LoggerFactory.getLogger(SSLUtils.class);
    private static SSLContext allTrustedSSLContext;

    private SSLUtils() {
    }

    public static SSLContext getAllTrustedCertificateSSLContext() {
        if (allTrustedSSLContext == null) {
            TrustManager[] trustAllCerts = new TrustManager[]{NoCheckTrustManager.INSTANCE};
            try {
                SSLContext sc = SSLContext.getInstance("TLSv1.2");
                sc.init(null, trustAllCerts, new SecureRandom());
                allTrustedSSLContext = sc;
            }
            catch (Exception e) {
                logger.warn("Failed in initialize ssl context", (Throwable)e);
                throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.ssl.context.init.failed"), (Throwable)e);
            }
        }
        return allTrustedSSLContext;
    }

    public static class NoCheckTrustManager
    implements X509TrustManager {
        public static final NoCheckTrustManager INSTANCE = new NoCheckTrustManager();

        private NoCheckTrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
        }
    }
}

