/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

public abstract class SystemUtils {
    private static final byte[] KEY = new byte[]{12, 7, 28, 127, 97, 69, 77, 122, 11};
    private static final String ENCRYPTED_PREFIX = "wm_-+";
    private static final String ENCRYPTED_SUFFIX = "==wm-_";

    private SystemUtils() {
    }

    public static String encrypt(String s) {
        s = ENCRYPTED_PREFIX + (String)s + ENCRYPTED_SUFFIX;
        StringBuilder rtn = new StringBuilder(((String)s).length());
        byte[] bytes = ((String)s).getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            rtn.append(SystemUtils.encrypt(bytes[i], KEY[i % KEY.length]));
        }
        return rtn.toString();
    }

    public static String encryptIfNotEncrypted(String s) {
        return SystemUtils.isEncrypted(s) ? s : SystemUtils.encrypt(s);
    }

    public static String decrypt(String s) {
        return SystemUtils.decrypt(s, true);
    }

    public static String decryptIfEncrypted(String s) {
        return SystemUtils.isEncrypted(s) ? SystemUtils.decrypt(s) : s;
    }

    private static String decrypt(String s, boolean removeMarkers) {
        byte[] rtn = new byte[s.length() / 2];
        int j = 0;
        for (int i = 0; i < s.length(); i += 2) {
            String hex = s.substring(i, i + 2);
            rtn[j] = (byte)(Integer.parseInt(hex, 16) ^ KEY[j % KEY.length]);
            ++j;
        }
        String d = new String(rtn);
        if (removeMarkers && SystemUtils.hasMarkers(d)) {
            return d.substring(ENCRYPTED_PREFIX.length(), d.length() - ENCRYPTED_SUFFIX.length());
        }
        return d;
    }

    public static boolean isEncrypted(String s) {
        if (s == null) {
            return false;
        }
        try {
            String d = SystemUtils.decrypt(s, false);
            return SystemUtils.hasMarkers(d);
        }
        catch (RuntimeException ex) {
            return false;
        }
    }

    private static boolean hasMarkers(String s) {
        return s.startsWith(ENCRYPTED_PREFIX) && s.endsWith(ENCRYPTED_SUFFIX);
    }

    private static String encrypt(byte b, byte key) {
        Object rtn = Integer.toHexString(b = (byte)(b ^ key));
        if (((String)rtn).length() == 1) {
            rtn = "0" + (String)rtn;
        }
        return rtn;
    }

    public static long getUnsignedValue(byte[] bytes) {
        long rtn = 0L;
        for (int i = 0; i < bytes.length; ++i) {
            boolean isSignBitSet;
            byte b = bytes[i];
            boolean bl = isSignBitSet = (b & 0x80) == 128;
            if (isSignBitSet) {
                b = (byte)(b & 0x7F);
            }
            rtn |= (long)b;
            if (isSignBitSet) {
                rtn |= 0x80L;
            }
            if (i >= bytes.length - 1) continue;
            rtn <<= 8;
        }
        return rtn;
    }

    public static Throwable getRootException(Throwable th) {
        while (th.getCause() != null) {
            th = th.getCause();
        }
        return th;
    }

    public static String getLineBreak() {
        return System.lineSeparator();
    }
}

