/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.InvalidInvocationException;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.Resource;
import com.wavemaker.commons.io.exception.ResourceException;
import com.wavemaker.commons.io.local.LocalFile;
import com.wavemaker.commons.io.local.LocalFolder;
import com.wavemaker.commons.util.FileAccessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public abstract class WMIOUtils {
    private static final Logger logger = LoggerFactory.getLogger(WMIOUtils.class);
    private static final int DEFAULT_BUFFER_SIZE = 1024;

    private WMIOUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(File f) throws IOException {
        String string;
        StringBuilder fileSB = new StringBuilder();
        char[] buf = new char[1024];
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(f));
            while (br.ready()) {
                int readlen = br.read(buf);
                fileSB.append(buf, 0, readlen);
            }
            string = fileSB.toString();
        }
        catch (Throwable throwable) {
            WMIOUtils.closeSilently(br);
            throw throwable;
        }
        WMIOUtils.closeSilently(br);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String tail(File f, int lines) throws IOException {
        String string;
        ArrayList<String> lineList = new ArrayList<String>(lines);
        BufferedReader br = null;
        try {
            String s;
            br = new BufferedReader(new FileReader(f));
            while (br.ready() && (s = br.readLine()) != null) {
                lineList.add(s);
                if (lineList.size() <= lines) continue;
                lineList.remove(0);
            }
            StringBuilder fileSB = new StringBuilder();
            for (String line : lineList) {
                fileSB.append(line).append('\n');
            }
            string = fileSB.toString();
        }
        catch (Throwable throwable) {
            WMIOUtils.closeSilently(br);
            throw throwable;
        }
        WMIOUtils.closeSilently(br);
        return string;
    }

    public static void write(File f, String s) throws IOException {
        f.getParentFile().mkdirs();
        WMIOUtils.write(new FileOutputStream(f), s);
    }

    public static void write(OutputStream outputStream, String data) throws IOException {
        try {
            IOUtils.write((String)data, (OutputStream)outputStream, (String)"UTF-8");
        }
        finally {
            WMIOUtils.closeSilently(outputStream);
        }
    }

    public static boolean compare(InputStream i1, InputStream i2) throws IOException {
        int b1 = 0;
        while ((b1 = i1.read()) != -1) {
            int b2 = i2.read();
            if (b2 == -1) {
                return false;
            }
            if (b1 == b2) continue;
            return false;
        }
        return i2.read() == -1;
    }

    public static void copyContent(com.wavemaker.commons.io.File sourceFile, com.wavemaker.commons.io.File destinationFile) {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = sourceFile.getContent().asInputStream();
            outputStream = destinationFile.getContent().asOutputStream();
            WMIOUtils.copy(inputStream, outputStream);
        }
        catch (IOException e) {
            try {
                throw new WMRuntimeException(e);
            }
            catch (Throwable throwable) {
                WMIOUtils.closeSilently(inputStream);
                WMIOUtils.closeSilently(outputStream);
                throw throwable;
            }
        }
        WMIOUtils.closeSilently(inputStream);
        WMIOUtils.closeSilently(outputStream);
    }

    public static int copy(InputStream is, OutputStream os) throws IOException {
        return IOUtils.copy((InputStream)is, (OutputStream)os);
    }

    public static int copy(Reader reader, Writer writer) throws IOException {
        return IOUtils.copy((Reader)reader, (Writer)writer);
    }

    public static void copy(File source, File destination) throws IOException {
        WMIOUtils.copy(source, destination, new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File destination, List<String> excludes) throws IOException {
        block10: {
            block11: {
                block9: {
                    if (!source.exists()) {
                        throw new IOException("Can't copy from non-existent file: " + source.getAbsolutePath());
                    }
                    if (excludes.contains(source.getName())) {
                        return;
                    }
                    if (!source.isDirectory()) break block9;
                    if (!destination.exists()) {
                        FileUtils.forceMkdir((File)destination);
                    }
                    if (!destination.isDirectory()) {
                        throw new IOException("Can't copy directory (" + source.getAbsolutePath() + ") to non-directory: " + destination.getAbsolutePath());
                    }
                    Object[] files = source.listFiles(new WMFileNameFilter());
                    if (ArrayUtils.isNotEmpty((Object[])files)) {
                        for (Object file : files) {
                            WMIOUtils.copy((File)file, new File(destination, ((File)file).getName()), excludes);
                        }
                    }
                    break block10;
                }
                if (!source.isFile()) break block11;
                if (destination.isDirectory()) {
                    destination = new File(destination, source.getName());
                }
                FileInputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = new FileInputStream(source);
                    outputStream = new FileOutputStream(destination);
                    WMIOUtils.copy(inputStream, outputStream);
                }
                catch (Throwable throwable) {
                    WMIOUtils.closeSilently(inputStream);
                    WMIOUtils.closeSilently(outputStream);
                    throw throwable;
                }
                WMIOUtils.closeSilently(inputStream);
                WMIOUtils.closeSilently(outputStream);
                break block10;
            }
            throw new IOException("Don't know how to copy " + source.getAbsolutePath() + "; it's neither a directory nor a file");
        }
    }

    public static void copy(File source, File destination, String includedPattern, String excludedPattern) throws IOException {
        ArrayList<String> includedPatterns = null;
        ArrayList<String> excludedPatterns = null;
        if (includedPattern != null) {
            includedPatterns = new ArrayList<String>();
            includedPatterns.add(includedPattern);
        }
        if (excludedPattern != null) {
            excludedPatterns = new ArrayList<String>();
            excludedPatterns.add(excludedPattern);
        }
        WMIOUtils.copy(source, destination, includedPatterns, excludedPatterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File destination, List<String> includedPatterns, List<String> excludedPatterns) throws IOException {
        block14: {
            block15: {
                block13: {
                    if (!source.exists()) {
                        throw new IOException("Can't copy from non-existent file: " + source.getAbsolutePath());
                    }
                    AntPathMatcher matcher = new AntPathMatcher();
                    boolean skip = false;
                    if (includedPatterns != null) {
                        for (String pattern : includedPatterns) {
                            if (matcher.match(pattern, source.getName())) break;
                        }
                    }
                    if (excludedPatterns != null) {
                        for (String pattern : excludedPatterns) {
                            if (!matcher.match(pattern, source.getName())) continue;
                            skip = true;
                            break;
                        }
                    }
                    if (skip) {
                        return;
                    }
                    if (!source.isDirectory()) break block13;
                    if (!destination.exists()) {
                        FileUtils.forceMkdir((File)destination);
                    }
                    if (!destination.isDirectory()) {
                        throw new IOException("Can't copy directory (" + source.getAbsolutePath() + ") to non-directory: " + destination.getAbsolutePath());
                    }
                    Object[] files = source.listFiles(new WMFileNameFilter());
                    if (ArrayUtils.isNotEmpty((Object[])files)) {
                        for (Object file : files) {
                            WMIOUtils.copy((File)file, new File(destination, ((File)file).getName()), includedPatterns, excludedPatterns);
                        }
                    }
                    break block14;
                }
                if (!source.isFile()) break block15;
                if (destination.isDirectory()) {
                    destination = new File(destination, source.getName());
                }
                FileInputStream inputStream = null;
                FileOutputStream outputStream = null;
                try {
                    inputStream = new FileInputStream(source);
                    outputStream = new FileOutputStream(destination);
                    WMIOUtils.copy(inputStream, outputStream);
                }
                catch (Throwable throwable) {
                    WMIOUtils.closeSilently(inputStream);
                    WMIOUtils.closeSilently(outputStream);
                    throw throwable;
                }
                WMIOUtils.closeSilently(inputStream);
                WMIOUtils.closeSilently(outputStream);
                break block14;
            }
            throw new IOException("Don't know how to copy " + source.getAbsolutePath() + "; it's neither a directory nor a file");
        }
    }

    public static void copyFile(com.wavemaker.commons.io.File srcFile, com.wavemaker.commons.io.File targetFile) throws IOException {
        FileUtils.copyFile((File)WMIOUtils.getJavaIOFile(srcFile), (File)WMIOUtils.getJavaIOFile(targetFile));
    }

    public static com.wavemaker.commons.io.File createTempFile(String prefix, String suffix) {
        try {
            if (((String)prefix).length() < 3) {
                prefix = (String)prefix + "000";
            }
            File tempFile = File.createTempFile((String)prefix, suffix);
            return new LocalFolder(tempFile.getParent()).getFile(tempFile.getName());
        }
        catch (IOException e) {
            throw new ResourceException(MessageResource.create("com.wavemaker.commons.failed.to.create.temp.file"), (Throwable)e);
        }
    }

    public static File createTempDirectory() throws IOException {
        return WMIOUtils.createTempDirectory("fileUtils_createTempDirectory");
    }

    public static Folder createTempFolder() {
        return WMIOUtils.createTempFolder("tempFolder");
    }

    public static Folder createTempFolder(String prefix) {
        try {
            return new LocalFolder(WMIOUtils.createTempDirectory(prefix));
        }
        catch (IOException e) {
            throw new ResourceException(MessageResource.create("com.wavemaker.commons.failed.to.create.temp.folder"), (Throwable)e);
        }
    }

    public static File createTempDirectory(String prefix) throws IOException {
        return Files.createTempDirectory(prefix, new FileAttribute[0]).toFile();
    }

    public static File createFile(String path) throws IOException {
        File file = new File(path);
        if (!file.exists()) {
            file.createNewFile();
        }
        return file;
    }

    public static void deleteRecursive(File dir) throws IOException {
        FileUtils.forceDelete((File)dir);
    }

    public static void cleanFolder(Folder folder) {
        if (folder == null) {
            return;
        }
        try {
            FileUtils.cleanDirectory((File)WMIOUtils.getJavaIOFile(folder));
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.folder.clean.error"), (Throwable)e, folder.getName());
        }
    }

    public static void cleanFolderSilently(Folder folder) {
        if (folder == null) {
            return;
        }
        WMIOUtils.cleanDirectorySilently(WMIOUtils.getJavaIOFile(folder));
    }

    public static void cleanDirectorySilently(File dir) {
        try {
            FileUtils.cleanDirectory((File)dir);
        }
        catch (IOException | IllegalArgumentException exception) {
            // empty catch block
        }
    }

    public static void deleteDirectorySilently(File dir) {
        WMIOUtils.deleteFileSilently(dir, true);
    }

    public static void deleteResourceSilently(Resource folder) {
        WMIOUtils.deleteResourceSilently(folder, true);
    }

    public static void deleteResourceSilently(Resource resource, boolean noLogging) {
        if (resource == null) {
            return;
        }
        File file = resource instanceof com.wavemaker.commons.io.File ? ((LocalFile)resource).getLocalFile() : ((LocalFolder)resource).getLocalFile();
        WMIOUtils.deleteFileSilently(file, noLogging);
    }

    public static String toString(Reader reader) {
        try {
            String string = IOUtils.toString((Reader)reader);
            return string;
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.get.string.from.input.stream"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeSilently(reader);
        }
    }

    public static String toString(InputStream is) {
        try {
            String string = IOUtils.toString((InputStream)is, (String)"UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.get.string.from.input.stream"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeSilently(is);
        }
    }

    public static void deleteFileSilently(File dir, boolean noLogging) {
        block3: {
            if (dir == null) {
                return;
            }
            try {
                FileUtils.forceDelete((File)dir);
            }
            catch (IOException e) {
                if (noLogging) break block3;
                logger.warn("Failed to delete the directory {}", (Object)dir, (Object)e);
            }
        }
    }

    public static void deleteFile(File file) {
        if (file.exists()) {
            file.delete();
        }
    }

    public static void makeDirectories(File newDir, File topLevel) throws FileAccessException {
        if (newDir.exists()) {
            return;
        }
        if (!topLevel.exists()) {
            throw new FileAccessException(MessageResource.UTIL_FILEUTILS_PATHDNE, topLevel);
        }
        if (!topLevel.isDirectory()) {
            throw new FileAccessException(MessageResource.UTIL_FILEUTILS_PATHNOTDIR, topLevel);
        }
        File absNewFile = newDir.getAbsoluteFile();
        WMIOUtils.makeDirectoriesRecurse(absNewFile, topLevel);
    }

    public static Collection<File> getFiles(File indir) {
        if (indir != null && !indir.isDirectory()) {
            throw new IllegalArgumentException("Expected directory as input");
        }
        HashSet<File> rtn = new HashSet<File>();
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(indir);
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.remove(0);
            Object[] files = dir.list();
            if (!ArrayUtils.isNotEmpty((Object[])files)) continue;
            for (Object s : files) {
                File f = new File(dir, (String)s);
                if (f.isDirectory()) {
                    dirs.add(f);
                    continue;
                }
                rtn.add(f);
            }
        }
        return rtn;
    }

    private static void makeDirectoriesRecurse(File dir, File topLevel) throws FileAccessException {
        if (dir.equals(topLevel)) {
            return;
        }
        for (File root : File.listRoots()) {
            if (!dir.equals(root)) continue;
            throw new FileAccessException(MessageResource.UTIL_FILEUTILS_REACHEDROOT, root, topLevel);
        }
        WMIOUtils.makeDirectoriesRecurse(dir.getParentFile(), topLevel);
        if (!dir.exists()) {
            dir.mkdir();
        }
    }

    public static void touch(File f) throws IOException {
        if (!f.exists()) {
            FileWriter fw = new FileWriter(f);
            fw.close();
        } else {
            f.setLastModified(System.currentTimeMillis());
        }
    }

    public static void closeSilently(AutoCloseable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exc) {
                logger.debug("Error while closing stream {}", (Object)stream);
            }
        }
    }

    public static void closeByLogging(AutoCloseable e) {
        if (e != null) {
            try {
                e.close();
            }
            catch (Exception exc) {
                logger.warn("Failed to close the autoCloseable", (Throwable)exc);
            }
        }
    }

    public static File getJavaIOFile(Resource resource) {
        if (resource instanceof LocalFile) {
            LocalFile localFile = (LocalFile)resource;
            return localFile.getLocalFile();
        }
        if (resource instanceof LocalFolder) {
            LocalFolder localFolder = (LocalFolder)resource;
            return localFolder.getLocalFile();
        }
        throw new InvalidInvocationException();
    }

    static class WMFileNameFilter
    implements FilenameFilter {
        WMFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.indexOf(35) == -1 && name.indexOf(126) == -1;
        }
    }
}

