/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.wrapper.BooleanWrapper;
import com.wavemaker.commons.wrapper.IntegerWrapper;
import com.wavemaker.commons.wrapper.StringWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class WMUtils {
    public static final String SUCCESS = "success";
    public static final StringWrapper SUCCESS_RESPONSE = new StringWrapper("success");

    private WMUtils() {
    }

    public static String getFileExtensionFromFileName(String fileName) {
        int indexOfDot = fileName.lastIndexOf(46);
        return indexOfDot == -1 ? "" : fileName.substring(indexOfDot + 1);
    }

    public static String decodeRequestURI(String requestURI) {
        try {
            return URLDecoder.decode(requestURI, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.decode.request.uri"), (Throwable)e);
        }
    }

    public static String[] getStringList(Object obj) {
        if (obj instanceof String) {
            return new String[]{(String)obj};
        }
        if (obj instanceof String[]) {
            return (String[])obj;
        }
        if (obj instanceof List) {
            List o = (List)obj;
            return o.toArray(new String[0]);
        }
        throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.unsupported.object.type"), obj.getClass());
    }

    public static StringWrapper wrapString(String response) {
        return new StringWrapper(response);
    }

    public static IntegerWrapper wrapInteger(Integer response) {
        return new IntegerWrapper(response);
    }

    public static BooleanWrapper wrapBoolean(Boolean response) {
        return new BooleanWrapper(response);
    }
}

