/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.util.DefaultYamlProcessor;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.YamlProcessor;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class WMYamlProcessor
extends DefaultYamlProcessor {
    protected void process(YamlProcessor.MatchCallback callback) {
        super.process((properties, map) -> {
            Map<String, Object> flattenedMap = this.getFlatMap(map);
            Properties customProperties = new Properties();
            customProperties.putAll(flattenedMap);
            callback.process(customProperties, map);
        });
    }

    private Map<String, Object> getFlatMap(Map<String, Object> source) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        this.buildFlatMap(result, source, null);
        return result;
    }

    private void buildFlatMap(Map<String, Object> result, Map<String, Object> source, @Nullable String path) {
        source.forEach((key, value) -> {
            if (StringUtils.hasText((String)path)) {
                key = ((String)key).startsWith("[") ? path + (String)key : path + "." + (String)key;
            }
            if (value instanceof String) {
                result.put((String)key, value);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                this.buildFlatMap(result, map, (String)key);
            } else if (value instanceof Collection) {
                result.put((String)key, value);
            } else {
                result.put((String)key, value != null ? value : "");
            }
        });
    }
}

