/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.util;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.io.File;
import com.wavemaker.commons.util.WMIOUtils;
import com.wavemaker.commons.util.XMLWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class XMLUtils {
    public static final String SCOPE_SEP = ".";

    private XMLUtils() {
    }

    public static String escape(String s) {
        return StringEscapeUtils.escapeXml((String)s);
    }

    public static XMLWriter newXMLWriter(PrintWriter pw) {
        XMLWriter rtn = new XMLWriter(pw, 4, 4);
        rtn.setTextOnSameLineAsParentElement(true);
        return rtn;
    }

    public static Map<String, String> attributesToMap(XMLStreamReader reader) {
        return XMLUtils.attributesToMap("", reader);
    }

    public static Map<String, String> attributesToMap(String scope, XMLStreamReader reader) {
        int numAttrs = reader.getAttributeCount();
        if (numAttrs == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> rtn = new HashMap<String, String>(numAttrs);
        for (int i = 0; i < numAttrs; ++i) {
            StringBuilder attrName = new StringBuilder();
            if (scope.length() > 0) {
                attrName.append(scope).append(SCOPE_SEP);
            }
            attrName.append(reader.getAttributeName(i));
            rtn.put(attrName.toString(), reader.getAttributeValue(i));
        }
        return rtn;
    }

    public static Document getDocument(File file) {
        return XMLUtils.getDocument(file.getContent().asInputStream());
    }

    public static Document getNewDocument() {
        return XMLUtils.getDocumentBuilder().newDocument();
    }

    public static Document getDocument(String input) {
        return XMLUtils.getDocument(IOUtils.toInputStream((String)input, (Charset)StandardCharsets.UTF_8));
    }

    public static Document getDocument(InputStream inputStream) {
        try {
            DocumentBuilder documentBuilder = XMLUtils.getDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            return document;
        }
        catch (IOException | SAXException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.xml.parse.error"), (Throwable)e);
        }
        finally {
            WMIOUtils.closeSilently(inputStream);
        }
    }

    public static void putSimpleTextElement(Document document, Element parentElement, String key, String value) {
        NodeList childNodes = parentElement.getChildNodes();
        boolean hasElement = false;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element element;
            if (childNodes.item(i).getNodeType() != 1 || !key.equals((element = (Element)childNodes.item(i)).getTagName())) continue;
            element.setTextContent(value);
            hasElement = true;
        }
        if (!hasElement) {
            Element element = document.createElement(key);
            element.setTextContent(value);
            parentElement.appendChild(element);
        }
    }

    public static List<Element> getFirstLevelElementsByTagName(Element element, String name) {
        NodeList allChilds = element.getElementsByTagName(name);
        ArrayList<Element> childElements = new ArrayList<Element>();
        for (int i = 0; i < allChilds.getLength(); ++i) {
            Node child = allChilds.item(i);
            if (!Objects.equals(child.getParentNode(), element)) continue;
            childElements.add((Element)child);
        }
        return childElements;
    }

    public static Document readDocument(InputStream inputStream) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilder documentBuilder = XMLUtils.getDocumentBuilder();
        return documentBuilder.parse(inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Document readDocument(File file) throws ParserConfigurationException, IOException, SAXException {
        Document document;
        InputStream inputStream = null;
        try {
            DocumentBuilder documentBuilder = XMLUtils.getDocumentBuilder();
            inputStream = file.getContent().asInputStream();
            document = documentBuilder.parse(inputStream);
        }
        catch (Throwable throwable) {
            WMIOUtils.closeSilently(inputStream);
            throw throwable;
        }
        WMIOUtils.closeSilently(inputStream);
        return document;
    }

    public static Document getNewDOMDocument() throws ParserConfigurationException {
        return XMLUtils.getDocumentBuilder().newDocument();
    }

    private static DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setNamespaceAware(true);
            return documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new WMRuntimeException(MessageResource.create("com.wavemaker.commons.failed.to.fetch.documentbuilder"), (Throwable)e);
        }
    }
}

