/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.commons.zip;

import com.wavemaker.commons.io.File;
import com.wavemaker.commons.io.Folder;
import com.wavemaker.commons.io.NoCloseInputStream;
import com.wavemaker.commons.io.Resources;
import com.wavemaker.commons.io.exception.ResourceException;
import com.wavemaker.commons.io.store.FolderStore;
import com.wavemaker.commons.io.store.StoredFolder;
import com.wavemaker.commons.util.WMIOUtils;
import com.wavemaker.commons.zip.ZipResourceStore;
import com.wavemaker.commons.zip.ZipResourcesStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.springframework.util.Assert;

public class ZipArchive
extends StoredFolder {
    private final ZipResourceStore.ZipFolderStore store;

    public ZipArchive(File zipFile) {
        this.store = new ZipResourceStore.ZipFolderStore(zipFile);
    }

    @Override
    protected FolderStore getStore() {
        return this.store;
    }

    public static void unpack(File file, Folder destination) {
        Assert.notNull((Object)file, (String)"File must not be null");
        Assert.notNull((Object)destination, (String)"Destination must not be null");
        ZipArchive.unpack(file.getContent().asInputStream(), destination);
    }

    public static void unpack(InputStream inputStream, Folder destination) {
        Assert.notNull((Object)inputStream, (String)"InputStream must not be null");
        Assert.notNull((Object)destination, (String)"Destination must not be null");
        destination.createIfMissing();
        ZipInputStream zip = new ZipInputStream(new BufferedInputStream(inputStream));
        try {
            NoCloseInputStream noCloseZip = new NoCloseInputStream(zip);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                if (entry.isDirectory()) {
                    destination.getFolder(entry.getName()).createIfMissing();
                } else {
                    destination.getFile(entry.getName()).getContent().write(noCloseZip);
                }
                entry = zip.getNextEntry();
            }
        }
        catch (IOException e) {
            throw new ResourceException(e);
        }
        finally {
            WMIOUtils.closeSilently(zip);
        }
    }

    public static void compress(Folder folder, File file) {
        InputStream inputStream = ZipArchive.compress(folder);
        file.getContent().write(inputStream);
    }

    public static InputStream compress(Folder folder) {
        return ZipArchive.compress(folder, (String)null);
    }

    public static InputStream compress(Folder folder, String prefix) {
        return ZipArchive.compress(folder.find(), prefix);
    }

    public static InputStream compress(Resources<?> resources) {
        return ZipArchive.compress(resources, null);
    }

    public static InputStream compress(Resources<?> resources, String prefix) {
        return new ZipResourcesStream(resources, prefix);
    }
}

