/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.aop;

import com.wavemaker.runtime.data.aop.CRUDMethodInvocationHandler;
import com.wavemaker.runtime.data.event.EntityPostDeleteEvent;
import com.wavemaker.runtime.data.event.EntityPreDeleteEvent;
import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;

class DeleteMethodInvocationHandler
implements CRUDMethodInvocationHandler {
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    DeleteMethodInvocationHandler() {
    }

    @Override
    public void preHandle(String serviceId, Class entityClass, Method method, Object[] args) {
        Object entityId = args[0];
        this.applicationEventPublisher.publishEvent(new EntityPreDeleteEvent(serviceId, entityClass, entityId));
    }

    @Override
    public void postHandle(String serviceId, Class entityClass, Method method, Object retVal) {
        this.applicationEventPublisher.publishEvent(new EntityPostDeleteEvent<Object>(serviceId, entityClass, retVal));
    }

    @Override
    public boolean matches(Class entityClass, Method method) {
        return "delete".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] != entityClass;
    }
}

