/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.aop;

import com.wavemaker.runtime.data.aop.CRUDMethodInvocationHandler;
import com.wavemaker.runtime.data.event.EntityPostFetchListEvent;
import com.wavemaker.runtime.data.event.EntityPreFetchListEvent;
import com.wavemaker.runtime.data.model.FetchQuery;
import java.lang.reflect.Method;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.data.domain.Page;

class FindAllMethodInvocationHandler
implements CRUDMethodInvocationHandler {
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    FindAllMethodInvocationHandler() {
    }

    @Override
    public void preHandle(String serviceId, Class entityClass, Method method, Object[] args) {
        String query = (String)args[0];
        FetchQuery fetchQuery = new FetchQuery(query);
        this.applicationEventPublisher.publishEvent(new EntityPreFetchListEvent(serviceId, entityClass, fetchQuery));
        args[0] = fetchQuery.getQuery();
    }

    @Override
    public void postHandle(String serviceId, Class entityClass, Method method, Object retVal) {
        this.applicationEventPublisher.publishEvent(new EntityPostFetchListEvent(serviceId, entityClass, (Page)retVal));
    }

    @Override
    public boolean matches(Class entityClass, Method method) {
        return "findAll".equals(method.getName()) && method.getParameterTypes().length >= 1 && method.getParameterTypes()[0] == String.class;
    }
}

