/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.constants;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public enum DBType {
    HSQL(List.of("hsqldb"), "hsqldb"),
    MYSQL(List.of("mariadb", "mysql"), "mysql"),
    POSTGRES(List.of("postgresql"), "postgresql"),
    ORACLE(List.of("oracle"), "oracle"),
    SQL_SERVER(List.of("sqlserver"), "sqlserver"),
    DB2(List.of("db2"), "db2"),
    SQLITE(List.of("sqllite"), "sqllite"),
    REDSHIFT(List.of("redshift"), "redshift"),
    SAP_HANA(List.of("sap"), "sap"),
    OTHER(List.of("other"), "other");

    private static final Map<String, DBType> valueVsDBType;
    private String springSessionSchemaType;
    private List<String> supportedJdbcProtocols;

    @JsonValue
    public String toValue() {
        return this.getSpringSessionSchemaType();
    }

    private DBType(List<String> supportedJdbcProtocols, String springSessionSchemaType) {
        this.supportedJdbcProtocols = supportedJdbcProtocols;
        this.springSessionSchemaType = springSessionSchemaType;
    }

    public List<String> getSupportedJdbcProtocols() {
        return this.supportedJdbcProtocols;
    }

    public String getSpringSessionSchemaType() {
        return this.springSessionSchemaType;
    }

    static {
        valueVsDBType = new HashMap<String, DBType>();
        for (DBType dbType : DBType.values()) {
            valueVsDBType.put(dbType.toValue(), dbType);
        }
    }
}

