/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.converters;

import com.wavemaker.commons.json.deserializer.WMLocalDateTimeDeSerializer;
import com.wavemaker.runtime.data.converters.JavaTypeConverter;
import com.wavemaker.runtime.data.model.JavaType;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class DateTimeConverter
implements JavaTypeConverter {
    @Override
    public Object fromString(String value) {
        return WMLocalDateTimeDeSerializer.getLocalDateTime((String)value);
    }

    @Override
    public Object fromDbValue(Object fromValue) {
        if (fromValue == null) {
            return null;
        }
        if (Timestamp.class.isInstance(fromValue)) {
            Timestamp timestamp = (Timestamp)fromValue;
            Date date = new Date(timestamp.getTime());
            return LocalDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
        }
        if (Date.class.isInstance(fromValue)) {
            return LocalDateTime.ofInstant(((Date)fromValue).toInstant(), ZoneId.systemDefault());
        }
        return WMLocalDateTimeDeSerializer.getLocalDateTime((String)String.valueOf(fromValue));
    }

    @Override
    public Object toDbValue(Object value, Class<?> toType) {
        if (value instanceof LocalDateTime) {
            Timestamp timeStamp = Timestamp.valueOf(((LocalDateTime)value).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            return JavaType.TIMESTAMP.toDbValue(timeStamp);
        }
        return value;
    }
}

