/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.converters;

import com.wavemaker.runtime.data.converters.HibernateBackedJavaTypeConverter;
import org.hibernate.HibernateException;
import org.hibernate.type.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringTypeConverter
extends HibernateBackedJavaTypeConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringTypeConverter.class);

    public StringTypeConverter() {
        super(StringType.INSTANCE.getJavaTypeDescriptor());
    }

    @Override
    public Object fromDbValue(Object value) {
        String convertedValue;
        try {
            convertedValue = (String)super.fromDbValue(value);
        }
        catch (HibernateException e) {
            if (byte[].class.equals(value.getClass())) {
                convertedValue = new String((byte[])value);
            }
            LOGGER.debug("Not a string instance type, using String.valueOf for conversion {}", (Object)e.getMessage());
            convertedValue = String.valueOf(value);
        }
        return convertedValue;
    }
}

