/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.converters;

import com.wavemaker.runtime.data.converters.ConverterUtil;
import com.wavemaker.runtime.data.converters.HibernateBackedJavaTypeConverter;
import java.lang.reflect.Method;
import java.sql.Timestamp;
import org.hibernate.type.TimestampType;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class TimestampTypeConverter
extends HibernateBackedJavaTypeConverter {
    public static final String ORACLE_SQL_TIMESTAMP = "oracle.sql.TIMESTAMP";

    public TimestampTypeConverter() {
        super(TimestampType.INSTANCE.getJavaTypeDescriptor());
    }

    @Override
    public Object fromString(String value) {
        Object numberValue = ConverterUtil.toLongIfPossible(value);
        if (numberValue instanceof Long) {
            return new Timestamp((Long)numberValue);
        }
        return super.fromString(value);
    }

    @Override
    public Object fromDbValue(Object value) {
        Object convertedValue = value;
        if (value != null && ORACLE_SQL_TIMESTAMP.equals(value.getClass().getCanonicalName())) {
            try {
                Class oracleTimestamp = ClassUtils.forName((String)ORACLE_SQL_TIMESTAMP, (ClassLoader)Thread.currentThread().getContextClassLoader());
                convertedValue = ReflectionUtils.invokeMethod((Method)ClassUtils.getMethod((Class)oracleTimestamp, (String)"timestampValue", (Class[])new Class[0]), (Object)value);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        } else {
            convertedValue = super.fromDbValue(value);
        }
        return convertedValue;
    }
}

