/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.commons.file.manager.ExportedFileManager;
import com.wavemaker.runtime.commons.file.model.DownloadResponse;
import com.wavemaker.runtime.commons.file.model.Downloadable;
import com.wavemaker.runtime.commons.file.model.ExportedFileContentWrapper;
import com.wavemaker.runtime.data.dao.WMGenericDao;
import com.wavemaker.runtime.data.dao.generators.EntityQueryGenerator;
import com.wavemaker.runtime.data.dao.generators.SimpleEntitiyQueryGenerator;
import com.wavemaker.runtime.data.dao.query.providers.AppRuntimeParameterProvider;
import com.wavemaker.runtime.data.dao.query.providers.RuntimeQueryProvider;
import com.wavemaker.runtime.data.dao.query.types.wmql.WMQLTypeHelper;
import com.wavemaker.runtime.data.dao.util.PageUtils;
import com.wavemaker.runtime.data.dao.util.QueryHelper;
import com.wavemaker.runtime.data.dao.validators.SortValidator;
import com.wavemaker.runtime.data.exception.EntityNotFoundException;
import com.wavemaker.runtime.data.export.DataExportOptions;
import com.wavemaker.runtime.data.export.DataExporter;
import com.wavemaker.runtime.data.export.ExportType;
import com.wavemaker.runtime.data.export.hqlquery.HqlQueryExtractor;
import com.wavemaker.runtime.data.expression.QueryFilter;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.hql.SelectQueryBuilder;
import com.wavemaker.runtime.data.model.AggregationInfo;
import com.wavemaker.runtime.data.util.CriteriaUtils;
import com.wavemaker.runtime.data.util.DaoUtils;
import com.wavemaker.runtime.data.util.HqlQueryHelper;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.ArrayUtils;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class WMGenericDaoImpl<E extends Serializable, I extends Serializable>
implements WMGenericDao<E, I> {
    protected Class<E> entityClass;
    protected EntityQueryGenerator<E, I> queryGenerator;
    protected SortValidator sortValidator;
    @Autowired
    private ExportedFileManager exportedFileManager;

    public abstract HibernateTemplate getTemplate();

    public abstract WMQLTypeHelper getWMQLTypeHelper();

    @PostConstruct
    public void init() {
        if (this.getTemplate() == null) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.hibernateTemplate.not.set"));
        }
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericSuperclass();
        this.entityClass = (Class)genericSuperclass.getActualTypeArguments()[0];
        this.sortValidator = new SortValidator();
        this.queryGenerator = new SimpleEntitiyQueryGenerator(this.entityClass);
    }

    @Override
    public E create(E entity) {
        this.getTemplate().save(entity);
        this.getTemplate().flush();
        return entity;
    }

    @Override
    public void update(E entity) {
        this.getTemplate().update(entity);
        this.getTemplate().flush();
    }

    @Override
    public void delete(E entity) {
        this.getTemplate().delete(entity);
    }

    @Override
    public E findById(I entityId) {
        SelectQueryBuilder builder = this.queryGenerator.findById(entityId);
        return (E)((Serializable)HqlQueryHelper.execute(this.getTemplate(), this.entityClass, builder, this.getWMQLTypeHelper()).orElseThrow(() -> new EntityNotFoundException(MessageResource.create((String)"com.wavemaker.runtime.no.entity.exists.for.given.id"), entityId)));
    }

    @Override
    public List<E> findByMultipleIds(List<I> ids, boolean orderedReturn) {
        List nonNullIds = ids.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List result = (List)this.getTemplate().execute(session -> session.byMultipleIds(this.entityClass).enableOrderedReturn(orderedReturn).multiLoad(nonNullIds));
        ArrayList<Serializable> resultWithNulls = new ArrayList<Serializable>(ids.size());
        int index = 0;
        for (Serializable id : ids) {
            if (id == null) {
                resultWithNulls.add(null);
                continue;
            }
            resultWithNulls.add((Serializable)result.get(index++));
        }
        return resultWithNulls;
    }

    @Override
    public E findByUniqueKey(Map<String, Object> fieldValueMap) {
        SelectQueryBuilder builder = this.queryGenerator.findBy(fieldValueMap);
        return (E)((Serializable)HqlQueryHelper.execute(this.getTemplate(), this.entityClass, builder, this.getWMQLTypeHelper()).orElseThrow(() -> new EntityNotFoundException(MessageResource.create((String)"com.wavemaker.runtime.entity.not.found.for.given.map"), fieldValueMap)));
    }

    @Override
    public Page<E> list(Pageable pageable) {
        return this.search(null, PageUtils.defaultIfNull(pageable));
    }

    @Override
    public Page getAssociatedObjects(Object value, String fieldName, String key, Pageable pageable) {
        Pageable validPageable = PageUtils.defaultIfNull(pageable);
        this.sortValidator.validate(validPageable, this.entityClass);
        return (Page)this.getTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(this.entityClass).createCriteria(fieldName);
            criteria.add((Criterion)Restrictions.eq((String)key, (Object)value));
            return CriteriaUtils.executeAndGetPageableData(criteria, validPageable, null);
        });
    }

    @Override
    public Page<E> search(QueryFilter[] queryFilters, Pageable pageable) {
        Pageable validPageable = PageUtils.defaultIfNull(pageable);
        this.sortValidator.validate(validPageable, this.entityClass);
        DaoUtils.validateQueryFilters(queryFilters);
        return (Page)this.getTemplate().execute(session -> {
            Criteria criteria = session.createCriteria(this.entityClass);
            HashSet<String> aliases = new HashSet<String>();
            if (ArrayUtils.isNotEmpty((Object[])queryFilters)) {
                for (QueryFilter queryFilter : queryFilters) {
                    String attributeName = queryFilter.getAttributeName();
                    CriteriaUtils.criteriaForRelatedProperty(criteria, attributeName, aliases);
                    Criterion criterion = CriteriaUtils.createCriterion(queryFilter);
                    criteria.add(criterion);
                }
            }
            return CriteriaUtils.executeAndGetPageableData(criteria, validPageable, aliases);
        });
    }

    @Override
    public Page<E> searchByQuery(String query, Pageable pageable) {
        Pageable validPageable = PageUtils.defaultIfNull(pageable);
        this.sortValidator.validate(validPageable, this.entityClass);
        SelectQueryBuilder builder = this.queryGenerator.searchByQuery(query);
        return HqlQueryHelper.execute(this.getTemplate(), this.entityClass, builder, validPageable, this.getWMQLTypeHelper());
    }

    @Override
    public long count() {
        return this.count("");
    }

    @Override
    public long count(String query) {
        return (Long)this.getTemplate().execute(session -> {
            WMQueryInfo queryInfo = this.queryGenerator.searchByQuery(query).build();
            return QueryHelper.getQueryResultCount(queryInfo, false, this.getTemplate(), this.getWMQLTypeHelper());
        });
    }

    @Override
    public Page<Map<String, Object>> getAggregatedValues(AggregationInfo aggregationInfo, Pageable pageable) {
        Pageable validPageable = PageUtils.defaultIfNull(pageable);
        this.sortValidator.validate(validPageable, this.entityClass);
        SelectQueryBuilder builder = this.queryGenerator.getAggregatedValues(aggregationInfo);
        Page<Map> result = HqlQueryHelper.execute(this.getTemplate(), Map.class, builder, validPageable, this.getWMQLTypeHelper());
        return result;
    }

    @Override
    public Downloadable export(ExportType exportType, String query, Pageable pageable) {
        String fileId = this.exportedFileManager.registerFile(this.entityClass.getSimpleName() + exportType.getExtension(), outputStream -> this.export(new DataExportOptions(exportType, pageable.getPageSize(), query), pageable, (OutputStream)outputStream));
        ExportedFileContentWrapper fileContents = this.exportedFileManager.getFileContent(fileId);
        return new DownloadResponse(fileContents.getInputStream(), "application/octet-stream", fileContents.getFileName());
    }

    @Override
    public void export(DataExportOptions options, Pageable pageable, OutputStream outputStream) {
        Pageable validPageable = PageUtils.overrideExportSize(pageable, options.getExportSize());
        this.sortValidator.validate(validPageable, this.entityClass);
        this.getTemplate().execute(session -> {
            WMQueryInfo queryInfo = this.queryGenerator.searchByQuery(options.getQuery()).build();
            RuntimeQueryProvider<E> queryProvider = RuntimeQueryProvider.from(queryInfo, this.entityClass);
            AppRuntimeParameterProvider provider = new AppRuntimeParameterProvider(queryInfo, session.getTypeHelper(), this.getWMQLTypeHelper());
            Query hqlQuery = queryProvider.getQuery(session, validPageable, provider);
            HqlQueryExtractor queryExtractor = new HqlQueryExtractor(hqlQuery.scroll());
            DataExporter.export(queryExtractor, options, this.entityClass, outputStream);
            return null;
        });
    }

    @Override
    public E refresh(E entity) {
        this.getTemplate().refresh(entity);
        return entity;
    }

    @Override
    public void evict(E entity) {
        this.getTemplate().evict(entity);
    }

    @Override
    public <T> T execute(HibernateCallback<T> callback) {
        return (T)this.getTemplate().execute(callback);
    }
}

