/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.annotations.TableTemporal;
import com.wavemaker.runtime.data.dao.WMGenericDaoImpl;
import com.wavemaker.runtime.data.dao.WMGenericTemporalDao;
import com.wavemaker.runtime.data.dao.generators.TemporalQueryGenerator;
import com.wavemaker.runtime.data.dao.query.types.RuntimeParameterTypeResolver;
import com.wavemaker.runtime.data.dao.util.PageUtils;
import com.wavemaker.runtime.data.dao.util.ParametersConfigurator;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.hql.DeleteQueryBuilder;
import com.wavemaker.runtime.data.hql.SelectQueryBuilder;
import com.wavemaker.runtime.data.hql.UpdateQueryBuilder;
import com.wavemaker.runtime.data.model.TemporalHistoryEntity;
import com.wavemaker.runtime.data.periods.PeriodClause;
import com.wavemaker.runtime.data.util.AnnotationUtils;
import com.wavemaker.runtime.data.util.HqlQueryHelper;
import com.wavemaker.runtime.data.util.PropertyDescription;
import java.beans.FeatureDescriptor;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Transient;
import org.hibernate.query.Query;
import org.springframework.beans.BeanUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.HibernateTemplate;

public abstract class WMGenericTemporalDaoImpl<E extends Serializable, I extends Serializable>
extends WMGenericDaoImpl<E, I>
implements WMGenericTemporalDao<E, I> {
    private Class<TemporalHistoryEntity<E>> historyClass;
    private List<PropertyDescriptor> updatableProperties;

    @Override
    @PostConstruct
    public void init() {
        TableTemporal temporal;
        super.init();
        if (this.entityClass.isAnnotationPresent(TableTemporal.class)) {
            temporal = this.entityClass.getAnnotation(TableTemporal.class);
            boolean applicationTemporalExists = Arrays.stream(temporal.value()).anyMatch(temporalType -> temporalType == TableTemporal.TemporalType.APPLICATION);
            if (applicationTemporalExists) {
                this.queryGenerator = new TemporalQueryGenerator(this.queryGenerator, TableTemporal.TemporalType.APPLICATION);
            }
        } else {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.tableTemporal.annotation.error"), new Object[]{this.entityClass.getName()});
        }
        this.historyClass = temporal.historyClass();
        this.updatableProperties = AnnotationUtils.findProperties(this.historyClass).stream().filter(description -> description.isAnnotationNotPresent(Id.class)).filter(description -> description.isAnnotationNotPresent(Transient.class)).filter(description -> {
            Optional<Column> optionalColumn = description.findAnnotation(Column.class);
            return optionalColumn.isPresent() && optionalColumn.get().updatable();
        }).map(PropertyDescription::getDescriptor).map(FeatureDescriptor::getName).map(name -> BeanUtils.getPropertyDescriptor((Class)this.entityClass, (String)name)).collect(Collectors.toList());
    }

    protected abstract HibernateTemplate getHistoryTemplate();

    @Override
    public Page<E> findByPeriod(List<PeriodClause> periodClauses, String query, Pageable pageable) {
        Pageable validPageable = PageUtils.defaultIfNull(pageable);
        this.sortValidator.validate(validPageable, this.historyClass);
        SelectQueryBuilder builder = (SelectQueryBuilder)new SelectQueryBuilder(this.historyClass).withFilter(query);
        periodClauses.forEach(builder::withPeriodClause);
        Page<TemporalHistoryEntity<E>> responsePage = HqlQueryHelper.execute(this.getHistoryTemplate(), this.historyClass, builder, validPageable, this.getWMQLTypeHelper());
        return responsePage.map(TemporalHistoryEntity::asParent);
    }

    @Override
    public Page<E> findByIdAndPeriod(Map<String, Object> identifier, List<PeriodClause> periodClauses, Pageable pageable) {
        Pageable validPageable = PageUtils.defaultIfNull(pageable);
        this.sortValidator.validate(validPageable, this.historyClass);
        SelectQueryBuilder builder = (SelectQueryBuilder)new SelectQueryBuilder(this.historyClass).withFilterConditions(identifier);
        periodClauses.forEach(builder::withPeriodClause);
        Page<TemporalHistoryEntity<E>> responsePage = HqlQueryHelper.execute(this.getHistoryTemplate(), this.historyClass, builder, validPageable, this.getWMQLTypeHelper());
        return responsePage.map(TemporalHistoryEntity::asParent);
    }

    @Override
    public int update(Map<String, Object> identifier, PeriodClause periodClause, E entity) {
        UpdateQueryBuilder builder = new UpdateQueryBuilder(this.historyClass);
        builder.withFilterConditions(identifier);
        builder.withPeriodClause(periodClause);
        this.updatableProperties.forEach(property -> {
            try {
                builder.withSetter(property.getName(), property.getReadMethod().invoke(entity, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.property.read.error"), (Throwable)e, new Object[]{property.getName()});
            }
        });
        return this.executeUpdateDeleteQuery(builder.build());
    }

    @Override
    public int update(PeriodClause periodClause, String filter, E entity) {
        UpdateQueryBuilder builder = new UpdateQueryBuilder(this.historyClass);
        builder.withFilter(filter);
        builder.withPeriodClause(periodClause);
        this.updatableProperties.forEach(property -> {
            try {
                builder.withSetter(property.getName(), property.getReadMethod().invoke(entity, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new WMRuntimeException("Error while reading property: " + property.getName() + " value", (Throwable)e);
            }
        });
        return this.executeUpdateDeleteQuery(builder.build());
    }

    @Override
    public int delete(Map<String, Object> identifier, PeriodClause periodClause) {
        DeleteQueryBuilder builder = new DeleteQueryBuilder(this.historyClass);
        builder.withFilterConditions(identifier);
        builder.withPeriodClause(periodClause);
        return this.executeUpdateDeleteQuery(builder.build());
    }

    @Override
    public int delete(PeriodClause periodClause, String filter) {
        DeleteQueryBuilder builder = new DeleteQueryBuilder(this.historyClass);
        builder.withFilter(filter);
        builder.withPeriodClause(periodClause);
        return this.executeUpdateDeleteQuery(builder.build());
    }

    private int executeUpdateDeleteQuery(WMQueryInfo queryInfo) {
        return (Integer)this.getHistoryTemplate().execute(session -> {
            Query query = session.createQuery(queryInfo.getQuery());
            ParametersConfigurator.configure(query, queryInfo.getParameterValueMap(this.getWMQLTypeHelper()), new RuntimeParameterTypeResolver(queryInfo.getParameters(), session.getTypeHelper(), this.getWMQLTypeHelper()));
            return query.executeUpdate();
        });
    }
}

