/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.callbacks;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.util.StringUtils;
import com.wavemaker.commons.util.TypeConversionUtils;
import com.wavemaker.runtime.data.model.CustomProcedure;
import com.wavemaker.runtime.data.model.CustomProcedureParam;
import com.wavemaker.runtime.data.util.ProceduresUtils;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Types;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.hibernate.Session;
import org.hibernate.dialect.OracleTypesHelper;
import org.hibernate.internal.SessionImpl;
import org.hibernate.query.NativeQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyNativeProcedureExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyNativeProcedureExecutor.class);
    private static final String CURSOR = "cursor";

    public static List<Object> executeProcedure(Session session, CustomProcedure procedure) {
        List<CustomProcedureParam> procedureParams = LegacyNativeProcedureExecutor.prepareParams(procedure.getProcedureParams());
        return LegacyNativeProcedureExecutor.executeNativeJDBCCall(session, procedure.getProcedureStr(), procedureParams);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static List<Object> executeNativeJDBCCall(Session session, String procedureStr, List<CustomProcedureParam> customParams) {
        try (Connection conn = ((SessionImpl)session).connection();){
            ArrayList<Object> arrayList;
            block28: {
                ArrayList<Object> responseWrapper;
                ArrayList<Integer> outParams;
                CallableStatement callableStatement;
                ArrayList<Integer> cursorPosition;
                block26: {
                    ArrayList<Object> typeName;
                    block27: {
                        block24: {
                            block25: {
                                cursorPosition = new ArrayList<Integer>();
                                NativeQuery sqlProcedure = session.createNativeQuery(procedureStr);
                                Set namedParams = sqlProcedure.getParameterMetadata().getNamedParameterNames();
                                String jdbcComplianceProcedure = ProceduresUtils.jdbcComplianceProcedure(procedureStr, namedParams);
                                LOGGER.info("JDBC converted procedure {}", (Object)jdbcComplianceProcedure);
                                callableStatement = conn.prepareCall(jdbcComplianceProcedure);
                                outParams = new ArrayList<Integer>();
                                for (int position = 0; position < customParams.size(); ++position) {
                                    CustomProcedureParam procedureParam = customParams.get(position);
                                    if (procedureParam.getProcedureParamType().isOutParam()) {
                                        LOGGER.info("Found out Parameter {}", (Object)procedureParam.getParamName());
                                        typeName = (String)StringUtils.splitPackageAndClass((String)procedureParam.getValueType()).getRight();
                                        Integer typeCode = LegacyNativeProcedureExecutor.getTypeCode((String)((Object)typeName));
                                        LOGGER.info("Found type code to be {}", (Object)typeCode);
                                        callableStatement.registerOutParameter(position + 1, (int)typeCode);
                                        if (((String)((Object)typeName)).equalsIgnoreCase(CURSOR)) {
                                            cursorPosition.add(position + 1);
                                        } else {
                                            outParams.add(position + 1);
                                        }
                                    }
                                    if (!procedureParam.getProcedureParamType().isInParam()) continue;
                                    callableStatement.setObject(position + 1, procedureParam.getParamValue());
                                }
                                LOGGER.info("Executing Procedure {}", (Object)procedureStr);
                                boolean resultType = callableStatement.execute();
                                responseWrapper = new ArrayList<Object>();
                                if (!resultType) break block24;
                                typeName = LegacyNativeProcedureExecutor.processResultSet(callableStatement.getResultSet());
                                if (callableStatement == null) break block25;
                                callableStatement.close();
                            }
                            return typeName;
                        }
                        if (!outParams.isEmpty() || !cursorPosition.isEmpty()) break block26;
                        typeName = responseWrapper;
                        if (callableStatement == null) break block27;
                        callableStatement.close();
                    }
                    return typeName;
                }
                try {
                    LinkedHashMap<String, Object> outData = new LinkedHashMap<String, Object>();
                    for (Integer outParam : outParams) {
                        outData.put(customParams.get(outParam - 1).getParamName(), callableStatement.getObject(outParam));
                    }
                    for (Integer cursorIndex : cursorPosition) {
                        outData.put(customParams.get(cursorIndex - 1).getParamName(), LegacyNativeProcedureExecutor.processResultSet(callableStatement.getObject(cursorIndex)));
                    }
                    responseWrapper.add(outData);
                    arrayList = responseWrapper;
                    if (callableStatement == null) break block28;
                }
                catch (Throwable throwable) {
                    if (callableStatement != null) {
                        try {
                            callableStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                callableStatement.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.failed.to.execute.procedure"), (Throwable)e);
        }
    }

    private static List<CustomProcedureParam> prepareParams(List<CustomProcedureParam> customProcedureParams) {
        if (customProcedureParams != null && !customProcedureParams.isEmpty()) {
            for (CustomProcedureParam customProcedureParam : customProcedureParams) {
                Object processedParamValue;
                if (((String)StringUtils.splitPackageAndClass((String)customProcedureParam.getValueType()).getRight()).equalsIgnoreCase(CURSOR) || customProcedureParam.getProcedureParamType().isOutParam() || (processedParamValue = LegacyNativeProcedureExecutor.getValueObject(customProcedureParam)) == null) continue;
                customProcedureParam.setParamValue(processedParamValue);
            }
        }
        return customProcedureParams;
    }

    private static Object getValueObject(CustomProcedureParam customProcedureParam) {
        Object paramValue;
        try {
            Class<?> loader = Class.forName(customProcedureParam.getValueType());
            paramValue = TypeConversionUtils.fromString(loader, (String)customProcedureParam.getParamValue().toString(), (boolean)false);
        }
        catch (IllegalArgumentException ex) {
            LOGGER.error("Failed to Convert param value for procedure", (Throwable)ex);
            throw new WMRuntimeException(ex.getMessage(), (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new WMRuntimeException(MessageResource.CLASS_NOT_FOUND, (Throwable)ex, new Object[]{customProcedureParam.getProcedureParamType()});
        }
        return paramValue;
    }

    private static List<Object> processResultSet(Object resultSet) {
        ResultSet rset = (ResultSet)resultSet;
        ArrayList<Object> result = new ArrayList<Object>();
        try {
            while (rset.next()) {
                LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
                int colCount = rset.getMetaData().getColumnCount();
                for (int i = 1; i <= colCount; ++i) {
                    rowData.put(rset.getMetaData().getColumnName(i), rset.getObject(i));
                }
                result.add(rowData);
            }
        }
        catch (SQLException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.failed.to.process.cursor"), (Throwable)e);
        }
        return result;
    }

    private static Integer getTypeCode(String typeName) throws IllegalAccessException, NoSuchFieldException {
        Integer typeCode = typeName.equalsIgnoreCase(CURSOR) ? Integer.valueOf(OracleTypesHelper.INSTANCE.getOracleCursorTypeSqlType()) : Integer.valueOf(typeName.equals("String") ? 12 : (Integer)Types.class.getField(typeName.toUpperCase()).get(null));
        return typeCode;
    }
}

