/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.callbacks;

import com.wavemaker.runtime.data.dao.query.providers.PaginatedQueryProvider;
import com.wavemaker.runtime.data.dao.query.providers.ParametersProvider;
import com.wavemaker.runtime.data.export.DataExporter;
import com.wavemaker.runtime.data.export.ExportOptions;
import com.wavemaker.runtime.data.export.QueryExtractor;
import com.wavemaker.runtime.data.export.hqlquery.HqlQueryExtractor;
import com.wavemaker.runtime.data.export.nativesql.NativeQueryExtractor;
import com.wavemaker.runtime.data.export.util.DataSourceExporterUtil;
import com.wavemaker.runtime.data.transform.Transformers;
import java.io.OutputStream;
import java.sql.ResultSet;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class NamedQueryExporterCallback<R>
implements HibernateCallback<Void> {
    private final PaginatedQueryProvider<R> queryProvider;
    private final ParametersProvider parametersProvider;
    private final Pageable pageable;
    private final ExportOptions exportOptions;
    private final OutputStream outputStream;
    private final Class<R> responseType;

    public NamedQueryExporterCallback(PaginatedQueryProvider<R> queryProvider, ParametersProvider parametersProvider, Pageable pageable, ExportOptions exportOptions, OutputStream outputStream, Class<R> responseType) {
        this.queryProvider = queryProvider;
        this.parametersProvider = parametersProvider;
        this.pageable = pageable;
        this.exportOptions = exportOptions;
        this.outputStream = outputStream;
        this.responseType = responseType;
    }

    public Void doInHibernate(Session session) {
        QueryExtractor queryExtractor;
        Query<R> namedQuery = this.queryProvider.getQuery(session, this.pageable, this.parametersProvider);
        boolean isNative = namedQuery instanceof NativeQuery;
        if (isNative) {
            ResultSet resultSet = DataSourceExporterUtil.constructResultSet(namedQuery.scroll());
            queryExtractor = new NativeQueryExtractor(resultSet, Transformers.aliasToMappedClass(this.responseType));
        } else {
            queryExtractor = new HqlQueryExtractor(namedQuery.scroll());
        }
        DataExporter.export(queryExtractor, this.exportOptions, this.responseType, this.outputStream);
        return null;
    }
}

