/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.callbacks;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.dao.procedure.parameters.ResolvableParam;
import com.wavemaker.runtime.data.model.JavaType;
import com.wavemaker.runtime.data.model.procedures.ProcedureParameter;
import com.wavemaker.runtime.data.transform.Transformers;
import com.wavemaker.runtime.data.transform.WMResultTransformer;
import com.wavemaker.runtime.data.util.JDBCUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.orm.hibernate5.HibernateOperations;

public class NativeProcedureExecutor {
    public static final String CONTENT_FIELD = "content";

    private NativeProcedureExecutor() {
    }

    public static <T> T execute(HibernateOperations hibernateOperations, String jdbcQuery, List<ResolvableParam> params, Class<T> type) {
        return (T)hibernateOperations.execute(session -> session.doReturningWork(connection -> {
            CallableStatement statement = NativeProcedureExecutor.prepareStatement(connection, jdbcQuery, params);
            boolean resultSetType = statement.execute();
            Map<String, Object> result = NativeProcedureExecutor.getResultMap(statement, params, resultSetType, 0);
            return NativeProcedureExecutor.convert(result, type);
        }));
    }

    public static CallableStatement prepareStatement(Connection connection, String jdbcQuery, List<ResolvableParam> params) throws SQLException {
        CallableStatement statement = connection.prepareCall(jdbcQuery);
        NativeProcedureExecutor.configureParameters(statement, params);
        return statement;
    }

    public static Map<String, Object> getResultMap(CallableStatement statement, List<ResolvableParam> params, boolean resultSetType, int limit) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if (resultSetType) {
            result.put(CONTENT_FIELD, NativeProcedureExecutor.readResultSet(statement.getResultSet(), limit));
        }
        result.putAll(NativeProcedureExecutor.readResponse(statement, params, limit));
        return result;
    }

    public static List<Object> convertToOldResponse(Map result) {
        Object firstValue;
        List response = Collections.singletonList(result);
        if (result.keySet().size() == 1 && (firstValue = result.values().iterator().next()) instanceof List) {
            response = (List)firstValue;
        }
        return response;
    }

    protected static <T> T convert(Map<String, Object> object, Class<T> type) {
        WMResultTransformer transformer = Transformers.aliasToMappedClass(type);
        return (T)transformer.transformFromMap(object);
    }

    protected static void configureParameters(CallableStatement statement, List<ResolvableParam> params) throws SQLException {
        for (int i = 0; i < params.size(); ++i) {
            ResolvableParam param = params.get(i);
            if (param.getParameter().getParameterType().isOutParam()) {
                statement.registerOutParameter(i + 1, JDBCUtils.getSqlTypeCode(param.getParameter().getType()));
            }
            if (!param.getParameter().getParameterType().isInParam()) continue;
            if (param.getValue() != null) {
                if (param.getParameter().getType() == JavaType.BLOB) {
                    statement.setBlob(i + 1, (InputStream)new ByteArrayInputStream((byte[])param.getValue()));
                    continue;
                }
                if (param.getParameter().getType() == JavaType.CLOB) {
                    statement.setClob(i + 1, (Reader)new StringReader((String)param.getValue()));
                    continue;
                }
                statement.setObject(i + 1, param.getValue(), JDBCUtils.getSqlTypeCode(param.getParameter().getType()));
                continue;
            }
            statement.setNull(i + 1, JDBCUtils.getSqlTypeCode(param.getParameter().getType()));
        }
    }

    private static Map<String, Object> readResponse(CallableStatement statement, List<ResolvableParam> params, int limit) throws SQLException {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        for (int i = 0; i < params.size(); ++i) {
            List<Map<String, Object>> value;
            ResolvableParam param = params.get(i);
            ProcedureParameter parameter = param.getParameter();
            if (!parameter.getParameterType().isOutParam()) continue;
            List<Map<String, Object>> list = value = parameter.getType() == JavaType.BLOB ? statement.getBlob(i + 1) : statement.getObject(i + 1);
            if (parameter.getType() == JavaType.CURSOR) {
                value = NativeProcedureExecutor.readResultSet(value, limit);
            }
            result.put(parameter.getName(), value);
        }
        return result;
    }

    private static List<Map<String, Object>> readResultSet(Object resultSet, int limit) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        try {
            if (resultSet != null) {
                ResultSet rset = (ResultSet)resultSet;
                int row = 0;
                while ((limit < 1 || row++ < limit) && rset.next()) {
                    LinkedHashMap<String, Object> rowData = new LinkedHashMap<String, Object>();
                    int colCount = rset.getMetaData().getColumnCount();
                    for (int i = 1; i <= colCount; ++i) {
                        rowData.put(rset.getMetaData().getColumnLabel(i), rset.getObject(i));
                    }
                    result.add(rowData);
                }
            }
        }
        catch (SQLException e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.error.while.executing.procedure"), (Throwable)e);
        }
        return result;
    }
}

