/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.callbacks;

import com.wavemaker.runtime.data.dao.query.providers.PaginatedQueryProvider;
import com.wavemaker.runtime.data.dao.query.providers.ParametersProvider;
import java.util.List;
import java.util.Optional;
import javax.persistence.PersistenceException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.HibernateCallback;

public class PaginatedQueryCallback<R>
implements HibernateCallback<Page<R>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PaginatedQueryCallback.class);
    private final PaginatedQueryProvider<R> queryProvider;
    private final ParametersProvider parametersProvider;
    private final Pageable pageable;

    public PaginatedQueryCallback(PaginatedQueryProvider<R> queryProvider, ParametersProvider parametersProvider, Pageable pageable) {
        this.queryProvider = queryProvider;
        this.parametersProvider = parametersProvider;
        this.pageable = pageable;
    }

    public Page<R> doInHibernate(Session session) {
        Optional<Query<Number>> countQuery = this.queryProvider.getCountQuery(session, this.parametersProvider);
        long count = Integer.MAX_VALUE;
        try {
            Optional countOptional = countQuery.flatMap(Query::uniqueResultOptional);
            if (countOptional.isPresent()) {
                count = ((Number)countOptional.get()).longValue();
            }
        }
        catch (PersistenceException e) {
            LOGGER.warn("Count query execution failed, returning max value ERROR: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            LOGGER.warn("Count query execution failed, returning max value", (Throwable)e);
        }
        Query<R> selectQuery = this.queryProvider.getQuery(session, this.pageable, this.parametersProvider);
        List result = selectQuery.list();
        return new PageImpl(result, this.pageable, count);
    }
}

