/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.generators;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.data.dao.generators.IdentifierStrategy;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class CompositeIdentifierStrategy<Entity, Identifier>
implements IdentifierStrategy<Entity, Identifier> {
    private List<PropertyDescriptor> idProperties;

    public CompositeIdentifierStrategy(Class<Identifier> idClass) {
        this.idProperties = Arrays.stream(idClass.getDeclaredFields()).map(field -> BeanUtils.getPropertyDescriptor((Class)idClass, (String)field.getName())).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> extract(Identifier identifier) {
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        this.idProperties.forEach(idProperty -> {
            try {
                valuesMap.put(idProperty.getName(), idProperty.getReadMethod().invoke(identifier, new Object[0]));
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.unable.to.get.identifier.property"), (Throwable)e, new Object[]{idProperty.getName()});
            }
        });
        return valuesMap;
    }
}

