/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.generators;

import com.wavemaker.runtime.data.dao.generators.CompositeIdentifierStrategy;
import com.wavemaker.runtime.data.dao.generators.EntityQueryGenerator;
import com.wavemaker.runtime.data.dao.generators.IdentifierStrategy;
import com.wavemaker.runtime.data.dao.generators.SingleIdentifierStrategy;
import com.wavemaker.runtime.data.hql.SelectQueryBuilder;
import com.wavemaker.runtime.data.model.AggregationInfo;
import java.util.Map;
import javax.persistence.IdClass;

public class SimpleEntitiyQueryGenerator<E, I>
implements EntityQueryGenerator<E, I> {
    private final Class<E> entityClass;
    private final IdentifierStrategy<E, I> identifierStrategy;

    public SimpleEntitiyQueryGenerator(Class<E> entityClass) {
        this.entityClass = entityClass;
        if (entityClass.isAnnotationPresent(IdClass.class)) {
            IdClass idClass = entityClass.getAnnotation(IdClass.class);
            this.identifierStrategy = new CompositeIdentifierStrategy<E, I>(idClass.value());
        } else {
            this.identifierStrategy = new SingleIdentifierStrategy<E, I>(entityClass);
        }
    }

    @Override
    public SelectQueryBuilder findById(I identifier) {
        SelectQueryBuilder builder = SelectQueryBuilder.newBuilder(this.entityClass);
        builder.withFilterConditions(this.identifierStrategy.extract(identifier));
        return builder;
    }

    @Override
    public SelectQueryBuilder findBy(Map<String, Object> fieldValueMap) {
        return (SelectQueryBuilder)SelectQueryBuilder.newBuilder(this.entityClass).withFilterConditions(fieldValueMap);
    }

    @Override
    public SelectQueryBuilder searchByQuery(String query) {
        return (SelectQueryBuilder)SelectQueryBuilder.newBuilder(this.entityClass).withFilter(query);
    }

    @Override
    public SelectQueryBuilder getAggregatedValues(AggregationInfo aggregationInfo) {
        return SelectQueryBuilder.newBuilder(this.entityClass).withAggregationInfo(aggregationInfo);
    }
}

