/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.generators;

import com.wavemaker.runtime.data.annotations.TableTemporal;
import com.wavemaker.runtime.data.dao.generators.EntityQueryGenerator;
import com.wavemaker.runtime.data.dao.generators.QueryGeneratorDecorator;
import com.wavemaker.runtime.data.hql.SelectQueryBuilder;
import com.wavemaker.runtime.data.model.AggregationInfo;
import com.wavemaker.runtime.data.periods.AsOfClause;
import java.sql.Timestamp;

public class TemporalQueryGenerator<E, I>
extends QueryGeneratorDecorator<E, I> {
    private final TableTemporal.TemporalType type;

    public TemporalQueryGenerator(EntityQueryGenerator<E, I> delegate, TableTemporal.TemporalType type) {
        super(delegate);
        this.type = type;
    }

    @Override
    public SelectQueryBuilder searchByQuery(String query) {
        return (SelectQueryBuilder)super.searchByQuery(query).withPeriodClause(new AsOfClause(this.type, new Timestamp(System.currentTimeMillis())));
    }

    @Override
    public SelectQueryBuilder getAggregatedValues(AggregationInfo aggregationInfo) {
        return (SelectQueryBuilder)super.getAggregatedValues(aggregationInfo).withPeriodClause(new AsOfClause(this.type, new Timestamp(System.currentTimeMillis())));
    }
}

