/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.procedure;

import com.fasterxml.jackson.core.type.TypeReference;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.commons.json.JSONUtils;
import com.wavemaker.commons.util.WMIOUtils;
import com.wavemaker.runtime.data.dao.callbacks.NativeProcedureExecutor;
import com.wavemaker.runtime.data.dao.procedure.WMProcedureExecutor;
import com.wavemaker.runtime.data.dao.procedure.parameters.ResolvableParam;
import com.wavemaker.runtime.data.dao.procedure.parameters.RuntimeParameter;
import com.wavemaker.runtime.data.model.procedures.ProcedureParameter;
import com.wavemaker.runtime.data.model.procedures.RuntimeProcedure;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.hibernate5.HibernateOperations;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class WMProcedureExecutorImpl
implements WMProcedureExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(WMProcedureExecutorImpl.class);
    private Map<String, RuntimeProcedure> procedureMap;
    private HibernateTemplate template;
    private String serviceId;

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @PostConstruct
    protected void init() {
        InputStream resourceStream = null;
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            ClassLoader webAppClassLoader = WMProcedureExecutorImpl.class.getClassLoader();
            resourceStream = contextClassLoader.getResourceAsStream(this.serviceId + "-procedures.mappings.json");
            if (resourceStream != null) {
                LOGGER.info("Using the file {}-procedures.mappings.json from context classLoader {}", (Object)this.serviceId, (Object)contextClassLoader);
            } else {
                LOGGER.warn("Could not find {}-procedures.mappings.json in context classLoader {}", (Object)this.serviceId, (Object)contextClassLoader);
                resourceStream = webAppClassLoader.getResourceAsStream(this.serviceId + "-procedures.mappings.json");
                if (resourceStream == null) {
                    LOGGER.warn("Could not find {}-procedures.mappings.json in webApp classLoader {} also", (Object)this.serviceId, (Object)webAppClassLoader);
                    throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.procedures.mappings.not.found"), new Object[]{this.serviceId});
                }
                LOGGER.warn("Using the file {}-procedures.mappings.json from webApp classLoader {}", (Object)this.serviceId, (Object)webAppClassLoader);
            }
            this.procedureMap = (Map)JSONUtils.toObject((InputStream)resourceStream, (TypeReference)new TypeReference<Map<String, RuntimeProcedure>>(){});
        }
        catch (WMRuntimeException e) {
            try {
                throw e;
                catch (Exception e2) {
                    throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.mapping.procedures.mapping.file.failed"), (Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                WMIOUtils.closeSilently(resourceStream);
                throw throwable;
            }
        }
        WMIOUtils.closeSilently((AutoCloseable)resourceStream);
    }

    @Override
    public <T> T executeNamedProcedure(String procedureName, Map<String, Object> params, Class<T> type) {
        RuntimeProcedure procedure = this.procedureMap.get(procedureName);
        try {
            ArrayList<ResolvableParam> resolvableParams = new ArrayList<ResolvableParam>(procedure.getParameters().size());
            for (ProcedureParameter parameter : procedure.getParameters()) {
                resolvableParams.add(new RuntimeParameter(parameter, params));
            }
            return NativeProcedureExecutor.execute((HibernateOperations)this.template, procedure.getProcedureString(), resolvableParams, type);
        }
        catch (Exception e) {
            throw new WMRuntimeException(MessageResource.create((String)"com.wavemaker.runtime.named.procedure.execution.failed"), (Throwable)e);
        }
    }

    @Override
    public List<Object> executeNamedProcedure(String procedureName, Map<String, Object> params) {
        return NativeProcedureExecutor.convertToOldResponse(this.executeNamedProcedure(procedureName, params, Map.class));
    }
}

