/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.query;

import com.wavemaker.commons.WMRuntimeException;
import com.wavemaker.runtime.commons.file.model.DownloadResponse;
import com.wavemaker.runtime.commons.file.model.Downloadable;
import com.wavemaker.runtime.data.export.ExportOptions;
import com.wavemaker.runtime.data.export.ExportType;
import com.wavemaker.runtime.data.model.CustomQuery;
import com.wavemaker.runtime.data.model.QueryProcedureInput;
import com.wavemaker.runtime.data.model.UpdatableQueryInput;
import com.wavemaker.runtime.data.model.queries.RuntimeQuery;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

public interface WMQueryExecutor {
    default public <T> T executeNamedQuery(String queryName, Map<String, Object> params, Class<T> returnType) {
        return this.executeNamedQuery(new QueryProcedureInput<T>(queryName, params, returnType));
    }

    public <T> T executeNamedQuery(QueryProcedureInput<T> var1);

    default public <T> Page<T> executeNamedQuery(String queryName, Map<String, Object> params, Class<T> returnType, Pageable pageable) {
        return this.executeNamedQuery(new QueryProcedureInput<T>(queryName, params, returnType), pageable);
    }

    public <T> Page<T> executeNamedQuery(QueryProcedureInput<T> var1, Pageable var2);

    default public int executeNamedQueryForUpdate(String queryName, Map<String, Object> params) {
        return this.executeNamedQuery(new UpdatableQueryInput(queryName, params));
    }

    public int executeNamedQuery(UpdatableQueryInput var1);

    public Page<Object> executeRuntimeQuery(RuntimeQuery var1, Pageable var2);

    public int executeRuntimeQueryForUpdate(RuntimeQuery var1);

    default public Page<Object> executeNamedQuery(String queryName, Map<String, Object> params, Pageable pageable) {
        return this.executeNamedQuery(queryName, params, Object.class, pageable);
    }

    @Deprecated
    public Page<Object> executeCustomQuery(CustomQuery var1, Pageable var2);

    @Deprecated
    public int executeCustomQueryForUpdate(CustomQuery var1);

    @Deprecated
    default public <T> Downloadable exportNamedQueryData(String queryName, Map<String, Object> params, ExportType exportType, Class<T> responseType, Pageable pageable) {
        DownloadResponse downloadResponse;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            ExportOptions options = new ExportOptions(exportType, pageable.getPageSize());
            this.exportNamedQueryData(new QueryProcedureInput<T>(queryName, params, responseType), options, pageable, outputStream);
            downloadResponse = new DownloadResponse((InputStream)new ByteArrayInputStream(outputStream.toByteArray()), exportType.getContentType(), queryName + exportType.getExtension());
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new WMRuntimeException("Exception while closing out stream", (Throwable)e);
            }
        }
        outputStream.close();
        return downloadResponse;
    }

    public <T> void exportNamedQueryData(QueryProcedureInput<T> var1, ExportOptions var2, Pageable var3, OutputStream var4);
}

