/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.query;

import com.wavemaker.commons.MessageResource;
import com.wavemaker.runtime.data.dao.callbacks.NamedQueryExporterCallback;
import com.wavemaker.runtime.data.dao.callbacks.PaginatedQueryCallback;
import com.wavemaker.runtime.data.dao.callbacks.QueryCallback;
import com.wavemaker.runtime.data.dao.callbacks.UpdateQueryCallback;
import com.wavemaker.runtime.data.dao.query.WMQueryExecutor;
import com.wavemaker.runtime.data.dao.query.providers.AppRuntimeParameterProvider;
import com.wavemaker.runtime.data.dao.query.providers.RuntimeParametersProvider;
import com.wavemaker.runtime.data.dao.query.providers.RuntimeQueryProvider;
import com.wavemaker.runtime.data.dao.query.providers.SessionBackedQueryProvider;
import com.wavemaker.runtime.data.dao.query.types.SessionBackedParameterResolver;
import com.wavemaker.runtime.data.dao.util.CustomQueryAdapter;
import com.wavemaker.runtime.data.dao.util.PageUtils;
import com.wavemaker.runtime.data.exception.EntityNotFoundException;
import com.wavemaker.runtime.data.export.ExportOptions;
import com.wavemaker.runtime.data.model.CustomQuery;
import com.wavemaker.runtime.data.model.QueryProcedureInput;
import com.wavemaker.runtime.data.model.UpdatableQueryInput;
import com.wavemaker.runtime.data.model.queries.RuntimeQuery;
import java.io.OutputStream;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class WMQueryExecutorImpl
implements WMQueryExecutor {
    private HibernateTemplate template;
    private SessionBackedParameterResolver parameterResolvers;

    @PostConstruct
    private void init() {
        this.parameterResolvers = new SessionBackedParameterResolver((SessionFactoryImplementor)this.template.getSessionFactory());
    }

    @Override
    public <T> T executeNamedQuery(QueryProcedureInput<T> queryInput) {
        SessionBackedQueryProvider<T> queryProvider = new SessionBackedQueryProvider<T>(queryInput.getName(), queryInput.getResponseType());
        AppRuntimeParameterProvider parametersProvider = new AppRuntimeParameterProvider(queryInput.getParameters(), this.parameterResolvers.getResolver(queryInput.getName()));
        return ((Optional)this.template.execute(new QueryCallback<T>(queryProvider, parametersProvider))).orElseThrow(() -> new EntityNotFoundException(MessageResource.create((String)"com.wavemaker.runtime.no.row.exists"), queryInput.getParameters()));
    }

    @Override
    public <T> Page<T> executeNamedQuery(QueryProcedureInput<T> queryInput, Pageable pageable) {
        SessionBackedQueryProvider<T> queryProvider = new SessionBackedQueryProvider<T>(queryInput.getName(), queryInput.getResponseType());
        AppRuntimeParameterProvider parametersProvider = new AppRuntimeParameterProvider(queryInput.getParameters(), this.parameterResolvers.getResolver(queryInput.getName()));
        return (Page)this.template.execute(new PaginatedQueryCallback<T>(queryProvider, parametersProvider, PageUtils.defaultIfNull(pageable)));
    }

    @Override
    public int executeNamedQuery(UpdatableQueryInput queryInput) {
        SessionBackedQueryProvider<Integer> queryProvider = new SessionBackedQueryProvider<Integer>(queryInput.getName(), Integer.class);
        AppRuntimeParameterProvider parametersProvider = new AppRuntimeParameterProvider(queryInput.getParameters(), this.parameterResolvers.getResolver(queryInput.getName()));
        return (Integer)this.template.execute((HibernateCallback)new UpdateQueryCallback(queryProvider, parametersProvider));
    }

    @Override
    public Page<Object> executeRuntimeQuery(RuntimeQuery query, Pageable pageable) {
        RuntimeQueryProvider<Object> queryProvider = RuntimeQueryProvider.from(query, Object.class);
        RuntimeParametersProvider parametersProvider = new RuntimeParametersProvider(query);
        return (Page)this.template.execute(new PaginatedQueryCallback<Object>(queryProvider, parametersProvider, PageUtils.defaultIfNull(pageable)));
    }

    @Override
    public int executeRuntimeQueryForUpdate(RuntimeQuery query) {
        RuntimeQueryProvider<Integer> queryProvider = RuntimeQueryProvider.from(query, Integer.class);
        RuntimeParametersProvider parametersProvider = new RuntimeParametersProvider(query);
        return (Integer)this.template.execute((HibernateCallback)new UpdateQueryCallback(queryProvider, parametersProvider));
    }

    @Override
    public Page<Object> executeCustomQuery(CustomQuery customQuery, Pageable pageable) {
        RuntimeQuery runtimeQuery = CustomQueryAdapter.adapt(customQuery);
        return this.executeRuntimeQuery(runtimeQuery, PageUtils.defaultIfNull(pageable));
    }

    @Override
    public int executeCustomQueryForUpdate(CustomQuery customQuery) {
        RuntimeQuery runtimeQuery = CustomQueryAdapter.adapt(customQuery);
        return this.executeRuntimeQueryForUpdate(runtimeQuery);
    }

    @Override
    public <T> void exportNamedQueryData(QueryProcedureInput<T> queryInput, ExportOptions exportOptions, Pageable pageable, OutputStream outputStream) {
        Pageable overridenPageable = PageUtils.overrideExportSize(PageUtils.defaultIfNull(pageable), exportOptions.getExportSize());
        SessionBackedQueryProvider<T> queryProvider = new SessionBackedQueryProvider<T>(queryInput.getName(), queryInput.getResponseType());
        AppRuntimeParameterProvider parameterProvider = new AppRuntimeParameterProvider(queryInput.getParameters(), this.parameterResolvers.getResolver(queryInput.getName()));
        NamedQueryExporterCallback<T> callback = new NamedQueryExporterCallback<T>(queryProvider, parameterProvider, overridenPageable, exportOptions, outputStream, queryInput.getResponseType());
        this.template.executeWithNativeSession(callback);
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }
}

