/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.query.providers;

import com.wavemaker.runtime.commons.variable.VariableType;
import com.wavemaker.runtime.commons.variable.VariableTypeHelper;
import com.wavemaker.runtime.data.dao.query.providers.ParametersProvider;
import com.wavemaker.runtime.data.dao.query.types.ParameterTypeResolver;
import com.wavemaker.runtime.data.dao.query.types.RuntimeParameterTypeResolver;
import com.wavemaker.runtime.data.dao.query.types.wmql.WMQLTypeHelper;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.Session;
import org.hibernate.TypeHelper;
import org.hibernate.type.Type;

public class AppRuntimeParameterProvider
implements ParametersProvider {
    private final Map<String, Object> parameters;
    private final ParameterTypeResolver resolver;

    public AppRuntimeParameterProvider(Map<String, Object> parameters, ParameterTypeResolver resolver) {
        this.parameters = parameters;
        this.resolver = resolver;
    }

    public AppRuntimeParameterProvider(WMQueryInfo queryInfo, TypeHelper typeHelper, WMQLTypeHelper wmqlTypeHelper) {
        this(queryInfo.getParameterValueMap(wmqlTypeHelper), new RuntimeParameterTypeResolver(queryInfo.getParameters(), typeHelper, wmqlTypeHelper));
    }

    @Override
    public Object getValue(Session session, String name) {
        Object value = this.parameters.get(name);
        if (value == null) {
            Pair variableInfo = VariableTypeHelper.fromVariableName((String)name);
            VariableType variableType = (VariableType)variableInfo.getLeft();
            String variableName = (String)variableInfo.getRight();
            if (variableType.isVariable()) {
                Optional<Type> type = this.getType(session, name);
                value = type.isPresent() ? variableType.getValue(variableName, type.get().getReturnedClass()) : variableType.getValue(variableName);
            }
        }
        return value;
    }

    @Override
    public Optional<Type> getType(Session session, String name) {
        return this.resolver.resolveType(name);
    }
}

