/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.query.providers;

import com.wavemaker.runtime.data.dao.query.providers.ParametersProvider;
import com.wavemaker.runtime.data.dao.util.QueryHelper;
import com.wavemaker.runtime.data.model.JavaType;
import com.wavemaker.runtime.data.model.queries.QueryParameter;
import com.wavemaker.runtime.data.model.queries.RuntimeQuery;
import com.wavemaker.runtime.data.util.HibernateUtils;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.type.Type;

public class RuntimeParametersProvider
implements ParametersProvider {
    private final RuntimeQuery query;
    private final Map<String, QueryParameter> parameterMap;

    public RuntimeParametersProvider(RuntimeQuery query) {
        this.query = query;
        this.parameterMap = query.getParameters().stream().collect(Collectors.toMap(QueryParameter::getName, parameter -> parameter));
    }

    @Override
    public Object getValue(Session session, String name) {
        if (this.parameterMap.containsKey(name)) {
            return QueryHelper.prepareParam(this.parameterMap.get(name), false);
        }
        return null;
    }

    @Override
    public Optional<Type> getType(Session session, String name) {
        if (this.parameterMap.containsKey(name)) {
            JavaType javaType = this.parameterMap.get(name).getType();
            return HibernateUtils.findType(session.getTypeHelper(), javaType.getClassName());
        }
        return Optional.empty();
    }
}

