/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.query.providers;

import com.wavemaker.runtime.data.dao.query.providers.PaginatedQueryProvider;
import com.wavemaker.runtime.data.dao.query.providers.QueryProvider;
import com.wavemaker.runtime.data.dao.util.QueryHelper;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.model.queries.RuntimeQuery;
import com.wavemaker.runtime.data.transform.Transformers;
import com.wavemaker.runtime.data.transform.WMResultTransformer;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.springframework.data.domain.Pageable;

public class RuntimeQueryProvider<R>
implements QueryProvider<R>,
PaginatedQueryProvider<R> {
    private final String queryString;
    private final String countQueryString;
    private final boolean nativeSql;
    private final Class<R> responseType;

    private RuntimeQueryProvider(Builder<R> builder) {
        this.queryString = builder.queryString;
        this.countQueryString = builder.countQueryString;
        this.nativeSql = builder.nativeSql;
        this.responseType = builder.responseType;
    }

    public static <R> RuntimeQueryProvider<R> from(RuntimeQuery query, Class<R> returnType) {
        String countQueryString = query.getCountQueryString();
        if (StringUtils.isBlank((CharSequence)countQueryString)) {
            countQueryString = QueryHelper.getCountQuery(query.getQueryString(), query.isNativeSql());
        }
        return RuntimeQueryProvider.newBuilder(returnType).withQueryString(query.getQueryString()).withCountQueryString(countQueryString).withNativeSql(query.isNativeSql()).build();
    }

    public static <R> RuntimeQueryProvider<R> from(WMQueryInfo queryInfo, Class<R> returnType) {
        String countQuery = QueryHelper.getCountQuery(queryInfo.getQuery(), false);
        return RuntimeQueryProvider.newBuilder(returnType).withQueryString(queryInfo.getQuery()).withCountQueryString(countQuery).withNativeSql(false).build();
    }

    public static <R> Builder<R> newBuilder(Class<R> responseType) {
        return new Builder<R>(responseType);
    }

    @Override
    public Query<R> getQuery(Session session, Pageable pageable) {
        String sortedQuery = this.queryString;
        if (pageable.getSort().isSorted()) {
            WMResultTransformer transformer = Transformers.aliasToMappedClass(this.responseType);
            sortedQuery = this.nativeSql ? QueryHelper.applySortingForNativeQuery(this.queryString, pageable.getSort(), transformer, ((SessionFactoryImplementor)session.getSessionFactory()).getDialect()) : QueryHelper.applySortingForHqlQuery(this.queryString, pageable.getSort(), transformer);
        }
        Query<R> hibernateQuery = this.createQuery(session, sortedQuery, this.responseType);
        if (!pageable.isUnpaged()) {
            hibernateQuery.setFirstResult((int)pageable.getOffset());
            hibernateQuery.setMaxResults(pageable.getPageSize());
        }
        return hibernateQuery;
    }

    @Override
    public Optional<Query<Number>> getCountQuery(Session session) {
        if (StringUtils.isNotBlank((CharSequence)this.countQueryString)) {
            return Optional.of(this.createQuery(session, this.countQueryString, Number.class));
        }
        return Optional.empty();
    }

    @Override
    public Query<R> getQuery(Session session) {
        return this.createQuery(session, this.queryString, this.responseType);
    }

    private <T> Query<T> createQuery(Session session, String queryString, Class<T> returnType) {
        NativeQuery hibernateQuery;
        if (this.nativeSql) {
            hibernateQuery = session.createNativeQuery(queryString);
            Transformers.aliasToMappedClassOptional(returnType).ifPresent(arg_0 -> ((Query)hibernateQuery).setResultTransformer(arg_0));
        } else {
            hibernateQuery = session.createQuery(queryString);
            if (hibernateQuery.getReturnAliases() != null && hibernateQuery.getReturnAliases().length != 0) {
                Transformers.aliasToMappedClassOptional(returnType).ifPresent(arg_0 -> ((Query)hibernateQuery).setResultTransformer(arg_0));
            }
        }
        return hibernateQuery;
    }

    public static final class Builder<R> {
        private String queryString;
        private String countQueryString;
        private boolean nativeSql;
        private Class<R> responseType;

        private Builder(Class<R> responseType) {
            this.responseType = responseType;
        }

        public Builder<R> withQueryString(String val) {
            this.queryString = val;
            return this;
        }

        public Builder<R> withCountQueryString(String val) {
            this.countQueryString = val;
            return this;
        }

        public Builder<R> withNativeSql(boolean val) {
            this.nativeSql = val;
            return this;
        }

        public RuntimeQueryProvider<R> build() {
            return new RuntimeQueryProvider(this);
        }
    }
}

