/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.query.providers;

import com.wavemaker.runtime.data.dao.query.providers.PaginatedQueryProvider;
import com.wavemaker.runtime.data.dao.query.providers.QueryProvider;
import com.wavemaker.runtime.data.dao.util.QueryHelper;
import com.wavemaker.runtime.data.transform.Transformers;
import com.wavemaker.runtime.data.transform.WMResultTransformer;
import java.util.Optional;
import javax.persistence.Entity;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.query.Query;
import org.hibernate.query.spi.NamedQueryRepository;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SessionBackedQueryProvider<R>
implements QueryProvider<R>,
PaginatedQueryProvider<R> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionBackedQueryProvider.class);
    private String name;
    private Class<R> responseType;

    public SessionBackedQueryProvider(String name, Class<R> responseType) {
        this.name = name;
        this.responseType = responseType;
    }

    @Override
    public Query<R> getQuery(Session session) {
        return this.getAndConfigureQuery(session, this.name, this.responseType);
    }

    @Override
    public Query<R> getQuery(Session session, Pageable pageable) {
        Sort sort = pageable.getSort();
        WMResultTransformer transformer = Transformers.aliasToMappedClass(this.responseType);
        Query<R> query = sort != null ? this.createSortedQuery(session, sort, transformer) : this.getAndConfigureQuery(session, this.name, this.responseType);
        if (!pageable.isUnpaged()) {
            query.setFirstResult((int)pageable.getOffset()).setMaxResults(pageable.getPageSize());
        }
        return query;
    }

    @Override
    public Optional<Query<Number>> getCountQuery(Session session) {
        Query<Number> query = null;
        String countQueryName = this.name + "__count";
        NamedQueryRepository repository = ((SessionFactoryImplementor)session.getSessionFactory()).getNamedQueryRepository();
        if (this.queryExists(repository, countQueryName)) {
            query = this.getAndConfigureQuery(session, countQueryName, Number.class);
        } else {
            LOGGER.debug("Count query not found for query:{}", (Object)this.name);
        }
        return Optional.ofNullable(query);
    }

    private <T> Query<T> getAndConfigureQuery(Session session, String name, Class<T> type) {
        Query query;
        if (this.isMappedType(type)) {
            query = session.createNamedQuery(name, type);
        } else {
            query = session.createNamedQuery(name);
            Transformers.aliasToMappedClassOptional(type).ifPresent(arg_0 -> ((Query)query).setResultTransformer(arg_0));
        }
        return query;
    }

    private Query<R> createSortedQuery(Session session, Sort sort, WMResultTransformer transformer) {
        Query query;
        NamedQueryRepository repository = ((SessionFactoryImplementor)session.getSessionFactory()).getNamedQueryRepository();
        if (repository.getNamedQueryDefinition(this.name) != null) {
            String sortedQuery = QueryHelper.applySortingForHqlQuery(repository.getNamedQueryDefinition(this.name).getQueryString(), sort, transformer);
            query = this.isMappedType(this.responseType) ? session.createQuery(sortedQuery, this.responseType) : session.createQuery(sortedQuery).setResultTransformer((ResultTransformer)transformer);
        } else if (repository.getNamedSQLQueryDefinition(this.name) != null) {
            String sortedQuery = QueryHelper.applySortingForNativeQuery(repository.getNamedSQLQueryDefinition(this.name).getQueryString(), sort, transformer, ((SessionFactoryImplementor)session.getSessionFactory()).getDialect());
            query = session.createNativeQuery(sortedQuery).setResultTransformer((ResultTransformer)transformer);
        } else {
            throw ((SessionImplementor)session).getExceptionConverter().convert((RuntimeException)new IllegalArgumentException("No query defined for that name [" + this.name + "]"));
        }
        return query;
    }

    private boolean queryExists(NamedQueryRepository repository, String countQueryName) {
        return repository.getNamedQueryDefinition(countQueryName) != null || repository.getNamedSQLQueryDefinition(countQueryName) != null;
    }

    private boolean isMappedType(Class<?> type) {
        return type.isAnnotationPresent(Entity.class);
    }
}

