/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.query.types;

import com.wavemaker.runtime.data.dao.query.types.ParameterTypeResolver;
import com.wavemaker.runtime.data.dao.query.types.wmql.WMQLTypeHelper;
import com.wavemaker.runtime.data.filter.WMQueryParamInfo;
import com.wavemaker.runtime.data.model.JavaType;
import com.wavemaker.runtime.data.model.queries.QueryParameter;
import com.wavemaker.runtime.data.model.queries.RuntimeQuery;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.TypeHelper;
import org.hibernate.type.Type;

public class RuntimeParameterTypeResolver
implements ParameterTypeResolver {
    private final Map<String, Type> typesMap;

    public RuntimeParameterTypeResolver(List<QueryParameter> parameters, TypeHelper typeHelper) {
        this.typesMap = parameters.stream().collect(Collectors.toMap(QueryParameter::getName, queryParameter -> typeHelper.heuristicType(queryParameter.getType().getClassName())));
    }

    public RuntimeParameterTypeResolver(Map<String, WMQueryParamInfo> parameters, TypeHelper typeHelper, WMQLTypeHelper wmqlTypeHelper) {
        this.typesMap = new HashMap<String, Type>();
        for (Map.Entry<String, WMQueryParamInfo> queryParamInfoEntry : parameters.entrySet()) {
            String key = queryParamInfoEntry.getKey();
            JavaType javaType = queryParamInfoEntry.getValue().getJavaType();
            if (javaType == null) continue;
            if (wmqlTypeHelper != null) {
                javaType = wmqlTypeHelper.aliasFor(javaType);
            }
            this.typesMap.put(key, typeHelper.heuristicType(javaType.getClassName()));
        }
    }

    public static RuntimeParameterTypeResolver from(Session session, RuntimeQuery query) {
        return new RuntimeParameterTypeResolver(query.getParameters(), session.getSessionFactory().getTypeHelper());
    }

    @Override
    public Optional<Type> resolveType(String name) {
        return Optional.ofNullable(this.typesMap.get(name));
    }
}

