/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.query.types;

import com.wavemaker.runtime.data.dao.query.types.ParameterTypeResolver;
import com.wavemaker.runtime.data.util.HibernateUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.TypeHelper;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.TypeLocatorImpl;
import org.hibernate.query.spi.NamedQueryRepository;
import org.hibernate.type.Type;

public class SessionBackedParameterResolver {
    private final SessionFactoryImplementor factory;
    private final Map<String, ParameterTypeResolver> resolversCache;

    public SessionBackedParameterResolver(SessionFactoryImplementor factory) {
        this.factory = factory;
        this.resolversCache = new ConcurrentHashMap<String, ParameterTypeResolver>();
    }

    public ParameterTypeResolver getResolver(String queryName) {
        return this.resolversCache.computeIfAbsent(queryName, name -> {
            Map parameterTypes;
            HashMap typesMap = new HashMap();
            NamedQueryRepository repository = this.factory.getNamedQueryRepository();
            NamedQueryDefinition definition = repository.getNamedQueryDefinition(name);
            if (definition == null) {
                definition = repository.getNamedSQLQueryDefinition(name);
            }
            if ((parameterTypes = definition.getParameterTypes()) != null) {
                TypeLocatorImpl typeHelper = new TypeLocatorImpl(this.factory.getTypeResolver());
                parameterTypes.forEach((paramName, paramType) -> {
                    Optional<Type> typeOptional = HibernateUtils.findType((TypeHelper)typeHelper, paramType);
                    typeOptional.ifPresent(type -> typesMap.put(paramName, type));
                });
            }
            return parameterName -> Optional.ofNullable((Type)typesMap.get(parameterName));
        });
    }
}

