/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.util;

import com.wavemaker.runtime.commons.variable.VariableType;
import com.wavemaker.runtime.commons.variable.VariableTypeHelper;
import com.wavemaker.runtime.data.dao.query.types.HqlParameterTypeResolver;
import com.wavemaker.runtime.data.dao.query.types.ParameterTypeResolver;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.hibernate.query.Query;
import org.hibernate.type.Type;

public class ParametersConfigurator {
    private ParametersConfigurator() {
    }

    public static <R> Query<R> configure(Query<R> query, Map<String, Object> parameters) {
        return ParametersConfigurator.configure(query, parameters, new HqlParameterTypeResolver());
    }

    public static <R> Query<R> configure(Query<R> query, Map<String, Object> parameters, ParameterTypeResolver resolver) {
        query.getParameterMetadata().getNamedParameterNames().forEach(parameterName -> {
            Object value = ParametersConfigurator.getValue(parameters, parameterName);
            Optional<Type> typeOptional = resolver.resolveType((String)parameterName);
            boolean listType = Collection.class.isInstance(value);
            if (typeOptional.isPresent()) {
                if (listType) {
                    query.setParameterList(parameterName, (Collection)value, typeOptional.get());
                } else {
                    query.setParameter(parameterName, value, typeOptional.get());
                }
            } else if (listType) {
                query.setParameterList(parameterName, (Collection)value);
            } else {
                query.setParameter(parameterName, value);
            }
        });
        return query;
    }

    private static Object getValue(Map<String, Object> parameters, String parameterName) {
        Pair variableInfo;
        VariableType variableType;
        Object value = parameters.get(parameterName);
        if (value == null && (variableType = (VariableType)(variableInfo = VariableTypeHelper.fromVariableName((String)parameterName)).getLeft()).isVariable()) {
            String variableName = (String)variableInfo.getRight();
            value = variableType.getValue(variableName);
        }
        return value;
    }
}

