/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.util;

import com.wavemaker.runtime.data.dao.query.types.RuntimeParameterTypeResolver;
import com.wavemaker.runtime.data.dao.query.types.wmql.WMQLTypeHelper;
import com.wavemaker.runtime.data.dao.util.ParametersConfigurator;
import com.wavemaker.runtime.data.filter.WMQueryInfo;
import com.wavemaker.runtime.data.model.JavaType;
import com.wavemaker.runtime.data.model.procedures.ProcedureParameter;
import com.wavemaker.runtime.data.model.procedures.ProcedureParameterType;
import com.wavemaker.runtime.data.model.procedures.RuntimeProcedure;
import com.wavemaker.runtime.data.model.queries.QueryParameter;
import com.wavemaker.runtime.data.model.queries.RuntimeQuery;
import com.wavemaker.runtime.data.transform.Transformers;
import com.wavemaker.runtime.data.transform.WMResultTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.Session;
import org.hibernate.dialect.Dialect;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.hibernate.transform.ResultTransformer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class QueryHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryHelper.class);
    private static final String EMPTY_SPACE = " ";
    private static final String ORDER_PROPERTY_SEPARATOR = ",";
    private static final String BACK_TICK = "`";
    private static final String COUNT_QUERY_TEMPLATE = "select count(*) from ({0}) wmTempTable";
    private static final String ORDER_BY_QUERY_TEMPLATE = "select * from ({0}) wmTempTable";
    private static final String SELECT_COUNT1 = "select count(*) ";
    private static final String FROM = " FROM ";
    private static final String FROM_HQL = "FROM";
    private static final String GROUP_BY = " group by ";
    private static final String ORDER_BY = " order by ";

    private QueryHelper() {
    }

    public static String applySortingForNativeQuery(String queryString, Sort sort, WMResultTransformer transformer, Dialect dialect) {
        Object withOrderBy = queryString;
        if (sort != null && sort.iterator().hasNext()) {
            withOrderBy = ORDER_BY_QUERY_TEMPLATE.replace("{0}", queryString) + ORDER_BY + QueryHelper.buildOrderByClause(sort, ((Function<String, String>)transformer::aliasFromFieldName).andThen(QueryHelper::quoteWithBackTick).andThen(arg_0 -> ((Dialect)dialect).quote(arg_0)));
        }
        return withOrderBy;
    }

    public static String applySortingForHqlQuery(String queryString, Sort sort) {
        Object withOrderBy = queryString;
        if (sort != null && sort.iterator().hasNext()) {
            withOrderBy = queryString + ORDER_BY + QueryHelper.buildOrderByClause(sort, property -> property);
        }
        return withOrderBy;
    }

    public static String applySortingForHqlQuery(String queryString, Sort sort, WMResultTransformer transformer) {
        Object withOrderBy = queryString;
        if (sort != null && sort.iterator().hasNext()) {
            withOrderBy = queryString + ORDER_BY + QueryHelper.buildOrderByClause(sort, transformer::aliasFromFieldName);
        }
        return withOrderBy;
    }

    private static String buildOrderByClause(Sort sort, Function<String, String> fieldMapper) {
        StringBuilder orderBy = new StringBuilder();
        Iterator iterator = sort.iterator();
        while (iterator.hasNext()) {
            Sort.Order order = (Sort.Order)iterator.next();
            String property = fieldMapper.apply(order.getProperty());
            Sort.Direction direction = order.getDirection();
            if (direction == null) {
                direction = Sort.Direction.ASC;
            }
            orderBy.append(property).append(EMPTY_SPACE).append(direction.name());
            if (!iterator.hasNext()) continue;
            orderBy.append(ORDER_PROPERTY_SEPARATOR);
        }
        return orderBy.toString();
    }

    private static String quoteWithBackTick(String str) {
        if (!StringUtils.isNotBlank((CharSequence)str)) {
            return str;
        }
        if (str.charAt(0) != '`') {
            return BACK_TICK + str + BACK_TICK;
        }
        return str;
    }

    public static void setResultTransformer(Query query, Class<?> type) {
        if (query instanceof NativeQuery || query.getReturnAliases() != null && query.getReturnAliases().length != 0) {
            query.setResultTransformer((ResultTransformer)Transformers.aliasToMappedClass(type));
        }
    }

    public static Query createQuery(Session session, boolean isNative, String query) {
        return isNative ? session.createNativeQuery(query) : session.createQuery(query);
    }

    public static Long getQueryResultCount(WMQueryInfo wmQueryInfo, boolean isNative, HibernateTemplate template, WMQLTypeHelper wmqlTypeHelper) {
        return QueryHelper.getCountFromCountStringQuery(wmQueryInfo, isNative, template, wmqlTypeHelper);
    }

    private static Long getCountFromCountStringQuery(WMQueryInfo wmQueryInfo, boolean isNative, HibernateTemplate template, WMQLTypeHelper wmqlTypeHelper) {
        try {
            String strQuery = QueryHelper.getCountQuery(wmQueryInfo.getQuery(), isNative);
            if (strQuery == null) {
                return QueryHelper.maxCount();
            }
            return (Long)template.execute(session -> QueryHelper.executeCountQuery(session, isNative, strQuery, wmQueryInfo, wmqlTypeHelper));
        }
        catch (Exception ex) {
            LOGGER.error("Count query operation failed", (Throwable)ex);
            return QueryHelper.maxCount();
        }
    }

    public static Long executeCountQuery(Session session, boolean isNative, String strQuery, WMQueryInfo wmQueryInfo, WMQLTypeHelper wmqlTypeHelper) {
        NativeQuery query = isNative ? session.createNativeQuery(strQuery) : session.createQuery(strQuery);
        ParametersConfigurator.configure(query, wmQueryInfo.getParameterValueMap(wmqlTypeHelper), new RuntimeParameterTypeResolver(wmQueryInfo.getParameters(), session.getTypeHelper(), wmqlTypeHelper));
        Object result = query.uniqueResult();
        return result == null ? 0L : ((Number)result).longValue();
    }

    public static String getCountQuery(String query, boolean isNative) {
        query = query.trim();
        Object countQuery = null;
        if (isNative) {
            countQuery = COUNT_QUERY_TEMPLATE.replace("{0}", query);
            LOGGER.debug("Got count query string {}", countQuery);
        } else {
            int index = StringUtils.indexOfIgnoreCase((CharSequence)query, (CharSequence)GROUP_BY);
            if (index == -1 && (index = StringUtils.indexOfIgnoreCase((CharSequence)query, (CharSequence)FROM_HQL)) >= 0) {
                if (index != 0 && (index = StringUtils.indexOfIgnoreCase((CharSequence)query, (CharSequence)FROM)) > 0) {
                    query = query.substring(index);
                }
                if ((index = StringUtils.indexOfIgnoreCase((CharSequence)query, (CharSequence)ORDER_BY)) >= 0) {
                    query = query.substring(0, index);
                }
                countQuery = SELECT_COUNT1 + query;
            }
        }
        return countQuery;
    }

    private static long maxCount() {
        return Integer.MAX_VALUE;
    }

    public static List<ProcedureParameter> prepareProcedureParameters(RuntimeProcedure procedure) {
        List<ProcedureParameter> parameters = procedure.getParameters();
        for (ProcedureParameter parameter : parameters) {
            ProcedureParameterType parameterType = parameter.getParameterType();
            if (!parameterType.isInParam()) continue;
            parameter.setTestValue(QueryHelper.prepareParam(parameter, true));
        }
        return parameters;
    }

    public static Object prepareParam(QueryParameter parameter, boolean isNative) {
        Object convertedValue;
        if (parameter.isList()) {
            convertedValue = new ArrayList();
            for (Object object : (List)parameter.getTestValue()) {
                ((List)convertedValue).add(QueryHelper.convertValue(parameter, object, isNative));
            }
        } else {
            convertedValue = QueryHelper.convertValue(parameter, parameter.getTestValue(), isNative);
        }
        return convertedValue;
    }

    public static Object convertValue(QueryParameter parameter, Object value, boolean isNative) {
        String fromValue;
        JavaType javaType = parameter.getType();
        Object convertedValue = value;
        if (value != null && javaType != JavaType.BLOB && (StringUtils.isNotBlank((CharSequence)(fromValue = String.valueOf(value))) || parameter.getType() == JavaType.STRING)) {
            convertedValue = javaType.fromString(fromValue);
            if (isNative) {
                convertedValue = javaType.toDbValue(convertedValue);
            }
        }
        return convertedValue;
    }

    public static Query createQuery(RuntimeQuery runtimeQuery, Map<String, Object> params, Session session) {
        Object query = runtimeQuery.isNativeSql() ? QueryHelper.createNativeQuery(runtimeQuery.getQueryString(), params, session) : QueryHelper.createHQLQuery(runtimeQuery.getQueryString(), params, session);
        return query;
    }

    public static NativeQuery createNativeQuery(String queryString, Map<String, Object> params, Session session) {
        NativeQuery sqlQuery = session.createNativeQuery(queryString);
        QueryHelper.setResultTransformer((Query)sqlQuery, Map.class);
        ParametersConfigurator.configure(sqlQuery, params);
        return sqlQuery;
    }

    public static Query createHQLQuery(String queryString, Map<String, Object> params, Session session) {
        Query hqlQuery = session.createQuery(queryString);
        QueryHelper.setResultTransformer(hqlQuery, Map.class);
        ParametersConfigurator.configure(hqlQuery, params);
        return hqlQuery;
    }
}

