/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.util;

import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SortedUnPagedRequest
implements Pageable {
    private final int page;
    private final int size;
    private final Sort sort;

    public SortedUnPagedRequest(int page, int size) {
        this(page, size, Sort.unsorted());
    }

    public SortedUnPagedRequest(int page, int size, Sort sort) {
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public int getPageNumber() {
        return this.page;
    }

    public int getPageSize() {
        return this.size;
    }

    public long getOffset() {
        return (long)this.page * (long)this.size;
    }

    public Sort getSort() {
        return this.sort;
    }

    public Pageable next() {
        return new SortedUnPagedRequest(this.getPageNumber() + 1, this.getPageSize(), this.getSort());
    }

    public Pageable previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    public Pageable first() {
        return new SortedUnPagedRequest(0, this.getPageSize(), this.getSort());
    }

    public Pageable withPage(int pageNumber) {
        return new SortedUnPagedRequest(this.getPageNumber(), this.getPageSize(), this.getSort());
    }

    public boolean hasPrevious() {
        return this.page > 0;
    }

    public SortedUnPagedRequest previous() {
        return this.getPageNumber() == 0 ? this : new SortedUnPagedRequest(this.getPageNumber() - 1, this.getPageSize(), this.getSort());
    }
}

