/*
 * Decompiled with CFR 0.152.
 */
package com.wavemaker.runtime.data.dao.validators;

import com.wavemaker.commons.InvalidInputException;
import com.wavemaker.commons.MessageResource;
import com.wavemaker.runtime.data.dao.validators.HqlPropertyResolver;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class SortValidator {
    public void validate(Pageable pageable, Class<?> entityClass) {
        if (pageable != null && pageable.getSort() != null) {
            Sort sort = pageable.getSort();
            for (Sort.Order order : sort) {
                String propertyName = order.getProperty();
                if (HqlPropertyResolver.findField(propertyName, entityClass).isPresent()) continue;
                throw new InvalidInputException(MessageResource.UNKNOWN_FIELD_NAME, new Object[]{propertyName});
            }
        }
    }
}

